// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Specifies the security posture to be used in the scale set. Minimum api-version: 2023-03-01.
 */
@Fluent
public final class SecurityPostureReferenceUpdate {
    /*
     * The security posture reference id in the form of
     * /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|
     * latest
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The list of virtual machine extension names to exclude when applying the security posture.
     */
    @JsonProperty(value = "excludeExtensions")
    private List<String> excludeExtensions;

    /*
     * Whether the security posture can be overridden by the user.
     */
    @JsonProperty(value = "isOverridable")
    private Boolean isOverridable;

    /**
     * Creates an instance of SecurityPostureReferenceUpdate class.
     */
    public SecurityPostureReferenceUpdate() {
    }

    /**
     * Get the id property: The security posture reference id in the form of
     * /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|latest.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The security posture reference id in the form of
     * /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|latest.
     * 
     * @param id the id value to set.
     * @return the SecurityPostureReferenceUpdate object itself.
     */
    public SecurityPostureReferenceUpdate withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the excludeExtensions property: The list of virtual machine extension names to exclude when applying the
     * security posture.
     * 
     * @return the excludeExtensions value.
     */
    public List<String> excludeExtensions() {
        return this.excludeExtensions;
    }

    /**
     * Set the excludeExtensions property: The list of virtual machine extension names to exclude when applying the
     * security posture.
     * 
     * @param excludeExtensions the excludeExtensions value to set.
     * @return the SecurityPostureReferenceUpdate object itself.
     */
    public SecurityPostureReferenceUpdate withExcludeExtensions(List<String> excludeExtensions) {
        this.excludeExtensions = excludeExtensions;
        return this;
    }

    /**
     * Get the isOverridable property: Whether the security posture can be overridden by the user.
     * 
     * @return the isOverridable value.
     */
    public Boolean isOverridable() {
        return this.isOverridable;
    }

    /**
     * Set the isOverridable property: Whether the security posture can be overridden by the user.
     * 
     * @param isOverridable the isOverridable value to set.
     * @return the SecurityPostureReferenceUpdate object itself.
     */
    public SecurityPostureReferenceUpdate withIsOverridable(Boolean isOverridable) {
        this.isOverridable = isOverridable;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
