// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations.
 */
@Fluent
public final class ScheduledEventsPolicy {
    /*
     * The configuration parameters used while creating userInitiatedRedeploy scheduled event setting creation.
     */
    @JsonProperty(value = "userInitiatedRedeploy")
    private UserInitiatedRedeploy userInitiatedRedeploy;

    /*
     * The configuration parameters used while creating userInitiatedReboot scheduled event setting creation.
     */
    @JsonProperty(value = "userInitiatedReboot")
    private UserInitiatedReboot userInitiatedReboot;

    /*
     * The configuration parameters used while publishing scheduledEventsAdditionalPublishingTargets.
     */
    @JsonProperty(value = "scheduledEventsAdditionalPublishingTargets")
    private ScheduledEventsAdditionalPublishingTargets scheduledEventsAdditionalPublishingTargets;

    /**
     * Creates an instance of ScheduledEventsPolicy class.
     */
    public ScheduledEventsPolicy() {
    }

    /**
     * Get the userInitiatedRedeploy property: The configuration parameters used while creating userInitiatedRedeploy
     * scheduled event setting creation.
     * 
     * @return the userInitiatedRedeploy value.
     */
    public UserInitiatedRedeploy userInitiatedRedeploy() {
        return this.userInitiatedRedeploy;
    }

    /**
     * Set the userInitiatedRedeploy property: The configuration parameters used while creating userInitiatedRedeploy
     * scheduled event setting creation.
     * 
     * @param userInitiatedRedeploy the userInitiatedRedeploy value to set.
     * @return the ScheduledEventsPolicy object itself.
     */
    public ScheduledEventsPolicy withUserInitiatedRedeploy(UserInitiatedRedeploy userInitiatedRedeploy) {
        this.userInitiatedRedeploy = userInitiatedRedeploy;
        return this;
    }

    /**
     * Get the userInitiatedReboot property: The configuration parameters used while creating userInitiatedReboot
     * scheduled event setting creation.
     * 
     * @return the userInitiatedReboot value.
     */
    public UserInitiatedReboot userInitiatedReboot() {
        return this.userInitiatedReboot;
    }

    /**
     * Set the userInitiatedReboot property: The configuration parameters used while creating userInitiatedReboot
     * scheduled event setting creation.
     * 
     * @param userInitiatedReboot the userInitiatedReboot value to set.
     * @return the ScheduledEventsPolicy object itself.
     */
    public ScheduledEventsPolicy withUserInitiatedReboot(UserInitiatedReboot userInitiatedReboot) {
        this.userInitiatedReboot = userInitiatedReboot;
        return this;
    }

    /**
     * Get the scheduledEventsAdditionalPublishingTargets property: The configuration parameters used while publishing
     * scheduledEventsAdditionalPublishingTargets.
     * 
     * @return the scheduledEventsAdditionalPublishingTargets value.
     */
    public ScheduledEventsAdditionalPublishingTargets scheduledEventsAdditionalPublishingTargets() {
        return this.scheduledEventsAdditionalPublishingTargets;
    }

    /**
     * Set the scheduledEventsAdditionalPublishingTargets property: The configuration parameters used while publishing
     * scheduledEventsAdditionalPublishingTargets.
     * 
     * @param scheduledEventsAdditionalPublishingTargets the scheduledEventsAdditionalPublishingTargets value to set.
     * @return the ScheduledEventsPolicy object itself.
     */
    public ScheduledEventsPolicy withScheduledEventsAdditionalPublishingTargets(
        ScheduledEventsAdditionalPublishingTargets scheduledEventsAdditionalPublishingTargets) {
        this.scheduledEventsAdditionalPublishingTargets = scheduledEventsAdditionalPublishingTargets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (userInitiatedRedeploy() != null) {
            userInitiatedRedeploy().validate();
        }
        if (userInitiatedReboot() != null) {
            userInitiatedReboot().validate();
        }
        if (scheduledEventsAdditionalPublishingTargets() != null) {
            scheduledEventsAdditionalPublishingTargets().validate();
        }
    }
}
