// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Describes an available Compute SKU Location Information.
 */
@Immutable
public final class ResourceSkuLocationInfo {
    /*
     * Location of the SKU
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * List of availability zones where the SKU is supported.
     */
    @JsonProperty(value = "zones", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> zones;

    /*
     * Details of capabilities available to a SKU in specific zones.
     */
    @JsonProperty(value = "zoneDetails", access = JsonProperty.Access.WRITE_ONLY)
    private List<ResourceSkuZoneDetails> zoneDetails;

    /*
     * The names of extended locations.
     */
    @JsonProperty(value = "extendedLocations", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> extendedLocations;

    /*
     * The type of the extended location.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private ExtendedLocationType type;

    /**
     * Creates an instance of ResourceSkuLocationInfo class.
     */
    public ResourceSkuLocationInfo() {
    }

    /**
     * Get the location property: Location of the SKU.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the zones property: List of availability zones where the SKU is supported.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Get the zoneDetails property: Details of capabilities available to a SKU in specific zones.
     * 
     * @return the zoneDetails value.
     */
    public List<ResourceSkuZoneDetails> zoneDetails() {
        return this.zoneDetails;
    }

    /**
     * Get the extendedLocations property: The names of extended locations.
     * 
     * @return the extendedLocations value.
     */
    public List<String> extendedLocations() {
        return this.extendedLocations;
    }

    /**
     * Get the type property: The type of the extended location.
     * 
     * @return the type value.
     */
    public ExtendedLocationType type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (zoneDetails() != null) {
            zoneDetails().forEach(e -> e.validate());
        }
    }
}
