// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey.
 */
@Fluent
public final class KeyVaultAndKeyReference {
    /*
     * Resource id of the KeyVault containing the key or secret
     */
    @JsonProperty(value = "sourceVault", required = true)
    private SourceVault sourceVault;

    /*
     * Url pointing to a key or secret in KeyVault
     */
    @JsonProperty(value = "keyUrl", required = true)
    private String keyUrl;

    /**
     * Creates an instance of KeyVaultAndKeyReference class.
     */
    public KeyVaultAndKeyReference() {
    }

    /**
     * Get the sourceVault property: Resource id of the KeyVault containing the key or secret.
     * 
     * @return the sourceVault value.
     */
    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: Resource id of the KeyVault containing the key or secret.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the KeyVaultAndKeyReference object itself.
     */
    public KeyVaultAndKeyReference withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the keyUrl property: Url pointing to a key or secret in KeyVault.
     * 
     * @return the keyUrl value.
     */
    public String keyUrl() {
        return this.keyUrl;
    }

    /**
     * Set the keyUrl property: Url pointing to a key or secret in KeyVault.
     * 
     * @param keyUrl the keyUrl value to set.
     * @return the KeyVaultAndKeyReference object itself.
     */
    public KeyVaultAndKeyReference withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceVault() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceVault in model KeyVaultAndKeyReference"));
        } else {
            sourceVault().validate();
        }
        if (keyUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyUrl in model KeyVaultAndKeyReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAndKeyReference.class);
}
