// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots.
 */
@Fluent
public final class KeyForDiskEncryptionSet {
    /*
     * Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the
     * KeyVault subscription is not the same as the Disk Encryption Set subscription.
     */
    @JsonProperty(value = "sourceVault")
    private SourceVault sourceVault;

    /*
     * Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of
     * rotationToLatestKeyVersionEnabled value.
     */
    @JsonProperty(value = "keyUrl", required = true)
    private String keyUrl;

    /**
     * Creates an instance of KeyForDiskEncryptionSet class.
     */
    public KeyForDiskEncryptionSet() {
    }

    /**
     * Get the sourceVault property: Resource id of the KeyVault containing the key or secret. This property is optional
     * and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     * 
     * @return the sourceVault value.
     */
    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: Resource id of the KeyVault containing the key or secret. This property is optional
     * and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the KeyForDiskEncryptionSet object itself.
     */
    public KeyForDiskEncryptionSet withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the keyUrl property: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is
     * required regardless of rotationToLatestKeyVersionEnabled value.
     * 
     * @return the keyUrl value.
     */
    public String keyUrl() {
        return this.keyUrl;
    }

    /**
     * Set the keyUrl property: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is
     * required regardless of rotationToLatestKeyVersionEnabled value.
     * 
     * @param keyUrl the keyUrl value to set.
     * @return the KeyForDiskEncryptionSet object itself.
     */
    public KeyForDiskEncryptionSet withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceVault() != null) {
            sourceVault().validate();
        }
        if (keyUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyUrl in model KeyForDiskEncryptionSet"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyForDiskEncryptionSet.class);
}
