// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The List Gallery Images operation response.
 */
@Fluent
public final class GalleryImageList {
    /*
     * A list of Shared Image Gallery images.
     */
    @JsonProperty(value = "value", required = true)
    private List<GalleryImageInner> value;

    /*
     * The uri to fetch the next page of Image Definitions in the Shared Image Gallery. Call ListNext() with this to
     * fetch the next page of gallery image definitions.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of GalleryImageList class.
     */
    public GalleryImageList() {
    }

    /**
     * Get the value property: A list of Shared Image Gallery images.
     * 
     * @return the value value.
     */
    public List<GalleryImageInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of Shared Image Gallery images.
     * 
     * @param value the value value to set.
     * @return the GalleryImageList object itself.
     */
    public GalleryImageList withValue(List<GalleryImageInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of Image Definitions in the Shared Image Gallery. Call
     * ListNext() with this to fetch the next page of gallery image definitions.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of Image Definitions in the Shared Image Gallery. Call
     * ListNext() with this to fetch the next page of gallery image definitions.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GalleryImageList object itself.
     */
    public GalleryImageList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model GalleryImageList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageList.class);
}
