// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Disk Restore Point details.
 */
@Fluent
public final class DiskRestorePointAttributes extends SubResourceReadOnly {
    /*
     * Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input
     * while creating a restore point.
     */
    @JsonProperty(value = "encryption")
    private RestorePointEncryption encryption;

    /*
     * Resource Id of the source disk restore point.
     */
    @JsonProperty(value = "sourceDiskRestorePoint")
    private ApiEntityReference sourceDiskRestorePoint;

    /**
     * Creates an instance of DiskRestorePointAttributes class.
     */
    public DiskRestorePointAttributes() {
    }

    /**
     * Get the encryption property: Encryption at rest settings for disk restore point. It is an optional property that
     * can be specified in the input while creating a restore point.
     * 
     * @return the encryption value.
     */
    public RestorePointEncryption encryption() {
        return this.encryption;
    }

    /**
     * Set the encryption property: Encryption at rest settings for disk restore point. It is an optional property that
     * can be specified in the input while creating a restore point.
     * 
     * @param encryption the encryption value to set.
     * @return the DiskRestorePointAttributes object itself.
     */
    public DiskRestorePointAttributes withEncryption(RestorePointEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the sourceDiskRestorePoint property: Resource Id of the source disk restore point.
     * 
     * @return the sourceDiskRestorePoint value.
     */
    public ApiEntityReference sourceDiskRestorePoint() {
        return this.sourceDiskRestorePoint;
    }

    /**
     * Set the sourceDiskRestorePoint property: Resource Id of the source disk restore point.
     * 
     * @param sourceDiskRestorePoint the sourceDiskRestorePoint value to set.
     * @return the DiskRestorePointAttributes object itself.
     */
    public DiskRestorePointAttributes withSourceDiskRestorePoint(ApiEntityReference sourceDiskRestorePoint) {
        this.sourceDiskRestorePoint = sourceDiskRestorePoint;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (encryption() != null) {
            encryption().validate();
        }
        if (sourceDiskRestorePoint() != null) {
            sourceDiskRestorePoint().validate();
        }
    }
}
