// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryImageInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The List Community Gallery Images operation response.
 */
@Fluent
public final class CommunityGalleryImageList {
    /*
     * A list of community gallery images.
     */
    @JsonProperty(value = "value", required = true)
    private List<CommunityGalleryImageInner> value;

    /*
     * The URI to fetch the next page of community gallery images. Call ListNext() with this to fetch the next page of
     * community gallery images.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of CommunityGalleryImageList class.
     */
    public CommunityGalleryImageList() {
    }

    /**
     * Get the value property: A list of community gallery images.
     * 
     * @return the value value.
     */
    public List<CommunityGalleryImageInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of community gallery images.
     * 
     * @param value the value value to set.
     * @return the CommunityGalleryImageList object itself.
     */
    public CommunityGalleryImageList withValue(List<CommunityGalleryImageInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of community gallery images. Call ListNext() with this
     * to fetch the next page of community gallery images.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of community gallery images. Call ListNext() with this
     * to fetch the next page of community gallery images.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CommunityGalleryImageList object itself.
     */
    public CommunityGalleryImageList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property value in model CommunityGalleryImageList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CommunityGalleryImageList.class);
}
