// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The List Availability Set operation response.
 */
@Fluent
public final class AvailabilitySetListResult {
    /*
     * The list of availability sets
     */
    @JsonProperty(value = "value", required = true)
    private List<AvailabilitySetInner> value;

    /*
     * The URI to fetch the next page of AvailabilitySets. Call ListNext() with this URI to fetch the next page of
     * AvailabilitySets.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of AvailabilitySetListResult class.
     */
    public AvailabilitySetListResult() {
    }

    /**
     * Get the value property: The list of availability sets.
     * 
     * @return the value value.
     */
    public List<AvailabilitySetInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of availability sets.
     * 
     * @param value the value value to set.
     * @return the AvailabilitySetListResult object itself.
     */
    public AvailabilitySetListResult withValue(List<AvailabilitySetInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this URI to
     * fetch the next page of AvailabilitySets.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this URI to
     * fetch the next page of AvailabilitySets.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AvailabilitySetListResult object itself.
     */
    public AvailabilitySetListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property value in model AvailabilitySetListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AvailabilitySetListResult.class);
}
