// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.DiskAccessesClient;
import com.azure.resourcemanager.compute.fluent.models.DiskAccessInner;
import com.azure.resourcemanager.compute.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.compute.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.DiskAccessList;
import com.azure.resourcemanager.compute.models.DiskAccessUpdate;
import com.azure.resourcemanager.compute.models.PrivateEndpointConnectionListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DiskAccessesClient.
 */
public final class DiskAccessesClientImpl implements InnerSupportsGet<DiskAccessInner>,
    InnerSupportsListing<DiskAccessInner>, InnerSupportsDelete<Void>, DiskAccessesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DiskAccessesService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DiskAccessesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DiskAccessesClientImpl(ComputeManagementClientImpl client) {
        this.service
            = RestProxy.create(DiskAccessesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientDiskAccesses to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    public interface DiskAccessesService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DiskAccessInner diskAccess, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DiskAccessUpdate diskAccess, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskAccessInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskAccessList>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/diskAccesses")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskAccessList>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateLinkResources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PrivateLinkResourceListResultInner>> getPrivateLinkResources(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> updateAPrivateEndpointConnection(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PrivateEndpointConnectionInner privateEndpointConnection,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<PrivateEndpointConnectionInner>> getAPrivateEndpointConnection(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAPrivateEndpointConnection(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName,
            @PathParam("privateEndpointConnectionName") String privateEndpointConnectionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<PrivateEndpointConnectionListResult>> listPrivateEndpointConnections(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskAccessName") String diskAccessName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskAccessList>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskAccessList>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<PrivateEndpointConnectionListResult>> listPrivateEndpointConnectionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String diskAccessName, DiskAccessInner diskAccess) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (diskAccess == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccess is required and cannot be null."));
        } else {
            diskAccess.validate();
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, diskAccessName, apiVersion, diskAccess, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String diskAccessName, DiskAccessInner diskAccess, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (diskAccess == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccess is required and cannot be null."));
        } else {
            diskAccess.validate();
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            diskAccessName, apiVersion, diskAccess, accept, context);
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DiskAccessInner>, DiskAccessInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String diskAccessName, DiskAccessInner diskAccess) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, diskAccessName, diskAccess);
        return this.client.<DiskAccessInner, DiskAccessInner>getLroResult(mono, this.client.getHttpPipeline(),
            DiskAccessInner.class, DiskAccessInner.class, this.client.getContext());
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DiskAccessInner>, DiskAccessInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String diskAccessName, DiskAccessInner diskAccess, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, diskAccessName, diskAccess, context);
        return this.client.<DiskAccessInner, DiskAccessInner>getLroResult(mono, this.client.getHttpPipeline(),
            DiskAccessInner.class, DiskAccessInner.class, context);
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiskAccessInner>, DiskAccessInner> beginCreateOrUpdate(String resourceGroupName,
        String diskAccessName, DiskAccessInner diskAccess) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, diskAccessName, diskAccess).getSyncPoller();
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiskAccessInner>, DiskAccessInner> beginCreateOrUpdate(String resourceGroupName,
        String diskAccessName, DiskAccessInner diskAccess, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, diskAccessName, diskAccess, context).getSyncPoller();
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskAccessInner> createOrUpdateAsync(String resourceGroupName, String diskAccessName,
        DiskAccessInner diskAccess) {
        return beginCreateOrUpdateAsync(resourceGroupName, diskAccessName, diskAccess).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiskAccessInner> createOrUpdateAsync(String resourceGroupName, String diskAccessName,
        DiskAccessInner diskAccess, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, diskAccessName, diskAccess, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskAccessInner createOrUpdate(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess) {
        return createOrUpdateAsync(resourceGroupName, diskAccessName, diskAccess).block();
    }

    /**
     * Creates or updates a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Put disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskAccessInner createOrUpdate(String resourceGroupName, String diskAccessName, DiskAccessInner diskAccess,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, diskAccessName, diskAccess, context).block();
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String diskAccessName,
        DiskAccessUpdate diskAccess) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (diskAccess == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccess is required and cannot be null."));
        } else {
            diskAccess.validate();
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, diskAccessName, apiVersion, diskAccess, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String diskAccessName,
        DiskAccessUpdate diskAccess, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (diskAccess == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccess is required and cannot be null."));
        } else {
            diskAccess.validate();
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            diskAccessName, apiVersion, diskAccess, accept, context);
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DiskAccessInner>, DiskAccessInner> beginUpdateAsync(String resourceGroupName,
        String diskAccessName, DiskAccessUpdate diskAccess) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, diskAccessName, diskAccess);
        return this.client.<DiskAccessInner, DiskAccessInner>getLroResult(mono, this.client.getHttpPipeline(),
            DiskAccessInner.class, DiskAccessInner.class, this.client.getContext());
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DiskAccessInner>, DiskAccessInner> beginUpdateAsync(String resourceGroupName,
        String diskAccessName, DiskAccessUpdate diskAccess, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, diskAccessName, diskAccess, context);
        return this.client.<DiskAccessInner, DiskAccessInner>getLroResult(mono, this.client.getHttpPipeline(),
            DiskAccessInner.class, DiskAccessInner.class, context);
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiskAccessInner>, DiskAccessInner> beginUpdate(String resourceGroupName,
        String diskAccessName, DiskAccessUpdate diskAccess) {
        return this.beginUpdateAsync(resourceGroupName, diskAccessName, diskAccess).getSyncPoller();
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of disk access resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiskAccessInner>, DiskAccessInner> beginUpdate(String resourceGroupName,
        String diskAccessName, DiskAccessUpdate diskAccess, Context context) {
        return this.beginUpdateAsync(resourceGroupName, diskAccessName, diskAccess, context).getSyncPoller();
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName,
        DiskAccessUpdate diskAccess) {
        return beginUpdateAsync(resourceGroupName, diskAccessName, diskAccess).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiskAccessInner> updateAsync(String resourceGroupName, String diskAccessName,
        DiskAccessUpdate diskAccess, Context context) {
        return beginUpdateAsync(resourceGroupName, diskAccessName, diskAccess, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskAccessInner update(String resourceGroupName, String diskAccessName, DiskAccessUpdate diskAccess) {
        return updateAsync(resourceGroupName, diskAccessName, diskAccess).block();
    }

    /**
     * Updates (patches) a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param diskAccess disk access object supplied in the body of the Patch disk access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskAccessInner update(String resourceGroupName, String diskAccessName, DiskAccessUpdate diskAccess,
        Context context) {
        return updateAsync(resourceGroupName, diskAccessName, diskAccess, context).block();
    }

    /**
     * Gets information about a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk access resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiskAccessInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String diskAccessName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, diskAccessName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets information about a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk access resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiskAccessInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String diskAccessName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            diskAccessName, apiVersion, accept, context);
    }

    /**
     * Gets information about a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk access resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskAccessInner> getByResourceGroupAsync(String resourceGroupName, String diskAccessName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, diskAccessName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets information about a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk access resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiskAccessInner> getByResourceGroupWithResponse(String resourceGroupName, String diskAccessName,
        Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, diskAccessName, context).block();
    }

    /**
     * Gets information about a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskAccessInner getByResourceGroup(String resourceGroupName, String diskAccessName) {
        return getByResourceGroupWithResponse(resourceGroupName, diskAccessName, Context.NONE).getValue();
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, diskAccessName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String diskAccessName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            diskAccessName, apiVersion, accept, context);
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String diskAccessName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, diskAccessName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String diskAccessName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, diskAccessName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String diskAccessName) {
        return this.beginDeleteAsync(resourceGroupName, diskAccessName).getSyncPoller();
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String diskAccessName,
        Context context) {
        return this.beginDeleteAsync(resourceGroupName, diskAccessName, context).getSyncPoller();
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String diskAccessName) {
        return beginDeleteAsync(resourceGroupName, diskAccessName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String diskAccessName, Context context) {
        return beginDeleteAsync(resourceGroupName, diskAccessName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String diskAccessName) {
        deleteAsync(resourceGroupName, diskAccessName).block();
    }

    /**
     * Deletes a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String diskAccessName, Context context) {
        deleteAsync(resourceGroupName, diskAccessName, context).block();
    }

    /**
     * Lists all the disk access resources under a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, apiVersion, accept, context))
            .<PagedResponse<DiskAccessInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the disk access resources under a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the disk access resources under a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiskAccessInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the disk access resources under a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiskAccessInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the disk access resources under a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskAccessInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Lists all the disk access resources under a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskAccessInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Lists all the disk access resources under a subscription.
     * 
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion,
                accept, context))
            .<PagedResponse<DiskAccessInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the disk access resources under a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the disk access resources under a subscription.
     * 
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiskAccessInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the disk access resources under a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiskAccessInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the disk access resources under a subscription.
     * 
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskAccessInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Lists all the disk access resources under a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskAccessInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Gets the private link resources possible under disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources possible under disk access resource along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PrivateLinkResourceListResultInner>>
        getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getPrivateLinkResources(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, diskAccessName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the private link resources possible under disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources possible under disk access resource along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceListResultInner>>
        getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String diskAccessName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getPrivateLinkResources(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, diskAccessName, apiVersion, accept, context);
    }

    /**
     * Gets the private link resources possible under disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources possible under disk access resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateLinkResourceListResultInner> getPrivateLinkResourcesAsync(String resourceGroupName,
        String diskAccessName) {
        return getPrivateLinkResourcesWithResponseAsync(resourceGroupName, diskAccessName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the private link resources possible under disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources possible under disk access resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PrivateLinkResourceListResultInner> getPrivateLinkResourcesWithResponse(String resourceGroupName,
        String diskAccessName, Context context) {
        return getPrivateLinkResourcesWithResponseAsync(resourceGroupName, diskAccessName, context).block();
    }

    /**
     * Gets the private link resources possible under disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources possible under disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateLinkResourceListResultInner getPrivateLinkResources(String resourceGroupName, String diskAccessName) {
        return getPrivateLinkResourcesWithResponse(resourceGroupName, diskAccessName, Context.NONE).getValue();
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Private Endpoint Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateAPrivateEndpointConnectionWithResponseAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName,
        PrivateEndpointConnectionInner privateEndpointConnection) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (privateEndpointConnection == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null."));
        } else {
            privateEndpointConnection.validate();
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateAPrivateEndpointConnection(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName,
                apiVersion, privateEndpointConnection, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Private Endpoint Connection resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateAPrivateEndpointConnectionWithResponseAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName,
        PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (privateEndpointConnection == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter privateEndpointConnection is required and cannot be null."));
        } else {
            privateEndpointConnection.validate();
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateAPrivateEndpointConnection(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, privateEndpointConnection,
            accept, context);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Private Endpoint Connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>
        beginUpdateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName,
            String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateAPrivateEndpointConnectionWithResponseAsync(resourceGroupName,
            diskAccessName, privateEndpointConnectionName, privateEndpointConnection);
        return this.client.<PrivateEndpointConnectionInner, PrivateEndpointConnectionInner>getLroResult(mono,
            this.client.getHttpPipeline(), PrivateEndpointConnectionInner.class, PrivateEndpointConnectionInner.class,
            this.client.getContext());
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Private Endpoint Connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>
        beginUpdateAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName,
            String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateAPrivateEndpointConnectionWithResponseAsync(resourceGroupName,
            diskAccessName, privateEndpointConnectionName, privateEndpointConnection, context);
        return this.client.<PrivateEndpointConnectionInner, PrivateEndpointConnectionInner>getLroResult(mono,
            this.client.getHttpPipeline(), PrivateEndpointConnectionInner.class, PrivateEndpointConnectionInner.class,
            context);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Private Endpoint Connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>
        beginUpdateAPrivateEndpointConnection(String resourceGroupName, String diskAccessName,
            String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        return this
            .beginUpdateAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
                privateEndpointConnectionName, privateEndpointConnection)
            .getSyncPoller();
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Private Endpoint Connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>
        beginUpdateAPrivateEndpointConnection(String resourceGroupName, String diskAccessName,
            String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection,
            Context context) {
        return this
            .beginUpdateAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
                privateEndpointConnectionName, privateEndpointConnection, context)
            .getSyncPoller();
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Private Endpoint Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateEndpointConnectionInner> updateAPrivateEndpointConnectionAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName,
        PrivateEndpointConnectionInner privateEndpointConnection) {
        return beginUpdateAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
            privateEndpointConnectionName, privateEndpointConnection).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Private Endpoint Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> updateAPrivateEndpointConnectionAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName,
        PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        return beginUpdateAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
            privateEndpointConnectionName, privateEndpointConnection, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Private Endpoint Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateEndpointConnectionInner updateAPrivateEndpointConnection(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName,
        PrivateEndpointConnectionInner privateEndpointConnection) {
        return updateAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName,
            privateEndpointConnection).block();
    }

    /**
     * Approve or reject a private endpoint connection under disk access resource, this can't be used to create a new
     * private endpoint connection.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param privateEndpointConnection private endpoint connection object supplied in the body of the Put private
     * endpoint connection operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Private Endpoint Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateEndpointConnectionInner updateAPrivateEndpointConnection(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName,
        PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        return updateAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName,
            privateEndpointConnection, context).block();
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a private endpoint connection under a disk access resource along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PrivateEndpointConnectionInner>> getAPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAPrivateEndpointConnection(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName,
                apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a private endpoint connection under a disk access resource along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PrivateEndpointConnectionInner>> getAPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String diskAccessName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAPrivateEndpointConnection(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, accept, context);
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a private endpoint connection under a disk access resource on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName) {
        return getAPrivateEndpointConnectionWithResponseAsync(resourceGroupName, diskAccessName,
            privateEndpointConnectionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a private endpoint connection under a disk access resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PrivateEndpointConnectionInner> getAPrivateEndpointConnectionWithResponse(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName, Context context) {
        return getAPrivateEndpointConnectionWithResponseAsync(resourceGroupName, diskAccessName,
            privateEndpointConnectionName, context).block();
    }

    /**
     * Gets information about a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a private endpoint connection under a disk access resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateEndpointConnectionInner getAPrivateEndpointConnection(String resourceGroupName, String diskAccessName,
        String privateEndpointConnectionName) {
        return getAPrivateEndpointConnectionWithResponse(resourceGroupName, diskAccessName,
            privateEndpointConnectionName, Context.NONE).getValue();
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAPrivateEndpointConnectionWithResponseAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteAPrivateEndpointConnection(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, diskAccessName, privateEndpointConnectionName,
                apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAPrivateEndpointConnectionWithResponseAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAPrivateEndpointConnection(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, diskAccessName, privateEndpointConnectionName, apiVersion, accept, context);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAPrivateEndpointConnectionAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAPrivateEndpointConnectionWithResponseAsync(resourceGroupName,
            diskAccessName, privateEndpointConnectionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAPrivateEndpointConnectionAsync(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAPrivateEndpointConnectionWithResponseAsync(resourceGroupName,
            diskAccessName, privateEndpointConnectionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAPrivateEndpointConnection(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName) {
        return this
            .beginDeleteAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
                privateEndpointConnectionName)
            .getSyncPoller();
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAPrivateEndpointConnection(String resourceGroupName,
        String diskAccessName, String privateEndpointConnectionName, Context context) {
        return this
            .beginDeleteAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
                privateEndpointConnectionName, context)
            .getSyncPoller();
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName,
        String privateEndpointConnectionName) {
        return beginDeleteAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
            privateEndpointConnectionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAPrivateEndpointConnectionAsync(String resourceGroupName, String diskAccessName,
        String privateEndpointConnectionName, Context context) {
        return beginDeleteAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName,
            privateEndpointConnectionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAPrivateEndpointConnection(String resourceGroupName, String diskAccessName,
        String privateEndpointConnectionName) {
        deleteAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName).block();
    }

    /**
     * Deletes a private endpoint connection under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAPrivateEndpointConnection(String resourceGroupName, String diskAccessName,
        String privateEndpointConnectionName, Context context) {
        deleteAPrivateEndpointConnectionAsync(resourceGroupName, diskAccessName, privateEndpointConnectionName, context)
            .block();
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>>
        listPrivateEndpointConnectionsSinglePageAsync(String resourceGroupName, String diskAccessName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listPrivateEndpointConnections(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, diskAccessName, apiVersion, accept, context))
            .<PagedResponse<PrivateEndpointConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsSinglePageAsync(
        String resourceGroupName, String diskAccessName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskAccessName == null) {
            return Mono.error(new IllegalArgumentException("Parameter diskAccessName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-02";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listPrivateEndpointConnections(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, diskAccessName, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PrivateEndpointConnectionInner> listPrivateEndpointConnectionsAsync(String resourceGroupName,
        String diskAccessName) {
        return new PagedFlux<>(() -> listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName),
            nextLink -> listPrivateEndpointConnectionsNextSinglePageAsync(nextLink));
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PrivateEndpointConnectionInner> listPrivateEndpointConnectionsAsync(String resourceGroupName,
        String diskAccessName, Context context) {
        return new PagedFlux<>(
            () -> listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, diskAccessName, context),
            nextLink -> listPrivateEndpointConnectionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PrivateEndpointConnectionInner> listPrivateEndpointConnections(String resourceGroupName,
        String diskAccessName) {
        return new PagedIterable<>(listPrivateEndpointConnectionsAsync(resourceGroupName, diskAccessName));
    }

    /**
     * List information about private endpoint connections under a disk access resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param diskAccessName The name of the disk access resource that is being created. The name can't be changed after
     * the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum
     * name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PrivateEndpointConnectionInner> listPrivateEndpointConnections(String resourceGroupName,
        String diskAccessName, Context context) {
        return new PagedIterable<>(listPrivateEndpointConnectionsAsync(resourceGroupName, diskAccessName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiskAccessInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiskAccessInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk access operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskAccessInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>>
        listPrivateEndpointConnectionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listPrivateEndpointConnectionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PrivateEndpointConnectionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of private link resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>>
        listPrivateEndpointConnectionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listPrivateEndpointConnectionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
