/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDetachOptionTypes;
import com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class DataDisk {
    @JsonProperty(value="lun", required=true)
    private int lun;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="vhd")
    private VirtualHardDisk vhd;
    @JsonProperty(value="image")
    private VirtualHardDisk image;
    @JsonProperty(value="caching")
    private CachingTypes caching;
    @JsonProperty(value="writeAcceleratorEnabled")
    private Boolean writeAcceleratorEnabled;
    @JsonProperty(value="createOption", required=true)
    private DiskCreateOptionTypes createOption;
    @JsonProperty(value="diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="managedDisk")
    private ManagedDiskParameters managedDisk;
    @JsonProperty(value="sourceResource")
    private ApiEntityReference sourceResource;
    @JsonProperty(value="toBeDetached")
    private Boolean toBeDetached;
    @JsonProperty(value="diskIOPSReadWrite", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskIopsReadWrite;
    @JsonProperty(value="diskMBpsReadWrite", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskMBpsReadWrite;
    @JsonProperty(value="detachOption")
    private DiskDetachOptionTypes detachOption;
    @JsonProperty(value="deleteOption")
    private DiskDeleteOptionTypes deleteOption;
    private static final ClientLogger LOGGER = new ClientLogger(DataDisk.class);

    public int lun() {
        return this.lun;
    }

    public DataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    public String name() {
        return this.name;
    }

    public DataDisk withName(String name) {
        this.name = name;
        return this;
    }

    public VirtualHardDisk vhd() {
        return this.vhd;
    }

    public DataDisk withVhd(VirtualHardDisk vhd) {
        this.vhd = vhd;
        return this;
    }

    public VirtualHardDisk image() {
        return this.image;
    }

    public DataDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public DataDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public DataDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public DataDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DataDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public DataDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public ApiEntityReference sourceResource() {
        return this.sourceResource;
    }

    public DataDisk withSourceResource(ApiEntityReference sourceResource) {
        this.sourceResource = sourceResource;
        return this;
    }

    public Boolean toBeDetached() {
        return this.toBeDetached;
    }

    public DataDisk withToBeDetached(Boolean toBeDetached) {
        this.toBeDetached = toBeDetached;
        return this;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskDetachOptionTypes detachOption() {
        return this.detachOption;
    }

    public DataDisk withDetachOption(DiskDetachOptionTypes detachOption) {
        this.detachOption = detachOption;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public DataDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.vhd() != null) {
            this.vhd().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.createOption() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property createOption in model DataDisk"));
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
        if (this.sourceResource() != null) {
            this.sourceResource().validate();
        }
    }
}

