// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the data disk to be detached.
 */
@Fluent
public final class DataDisksToDetach {
    /*
     * ID of the managed data disk.
     */
    @JsonProperty(value = "diskId", required = true)
    private String diskId;

    /*
     * Supported options available for Detach of a disk from a VM. Refer to DetachOption object reference for more
     * details.
     */
    @JsonProperty(value = "detachOption")
    private DiskDetachOptionTypes detachOption;

    /**
     * Creates an instance of DataDisksToDetach class.
     */
    public DataDisksToDetach() {
    }

    /**
     * Get the diskId property: ID of the managed data disk.
     * 
     * @return the diskId value.
     */
    public String diskId() {
        return this.diskId;
    }

    /**
     * Set the diskId property: ID of the managed data disk.
     * 
     * @param diskId the diskId value to set.
     * @return the DataDisksToDetach object itself.
     */
    public DataDisksToDetach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    /**
     * Get the detachOption property: Supported options available for Detach of a disk from a VM. Refer to DetachOption
     * object reference for more details.
     * 
     * @return the detachOption value.
     */
    public DiskDetachOptionTypes detachOption() {
        return this.detachOption;
    }

    /**
     * Set the detachOption property: Supported options available for Detach of a disk from a VM. Refer to DetachOption
     * object reference for more details.
     * 
     * @param detachOption the detachOption value to set.
     * @return the DataDisksToDetach object itself.
     */
    public DataDisksToDetach withDetachOption(DiskDetachOptionTypes detachOption) {
        this.detachOption = detachOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskId() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property diskId in model DataDisksToDetach"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToDetach.class);
}
