// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the data disk to be attached.
 */
@Fluent
public final class DataDisksToAttach {
    /*
     * ID of the managed data disk.
     */
    @JsonProperty(value = "diskId", required = true)
    private String diskId;

    /*
     * The logical unit number of the data disk. This value is used to identify data disks within the VM and therefore
     * must be unique for each data disk attached to a VM. If not specified, lun would be auto assigned.
     */
    @JsonProperty(value = "lun")
    private Integer lun;

    /*
     * Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting
     * behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JsonProperty(value = "caching")
    private CachingTypes caching;

    /*
     * Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If
     * this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data
     * disk is retained after VM is deleted. The default value is set to **Detach**.
     */
    @JsonProperty(value = "deleteOption")
    private DiskDeleteOptionTypes deleteOption;

    /*
     * Specifies the customer managed disk encryption set resource id for the managed disk.
     */
    @JsonProperty(value = "diskEncryptionSet")
    private DiskEncryptionSetParameters diskEncryptionSet;

    /*
     * Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JsonProperty(value = "writeAcceleratorEnabled")
    private Boolean writeAcceleratorEnabled;

    /**
     * Creates an instance of DataDisksToAttach class.
     */
    public DataDisksToAttach() {
    }

    /**
     * Get the diskId property: ID of the managed data disk.
     * 
     * @return the diskId value.
     */
    public String diskId() {
        return this.diskId;
    }

    /**
     * Set the diskId property: ID of the managed data disk.
     * 
     * @param diskId the diskId value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    /**
     * Get the lun property: The logical unit number of the data disk. This value is used to identify data disks within
     * the VM and therefore must be unique for each data disk attached to a VM. If not specified, lun would be auto
     * assigned.
     * 
     * @return the lun value.
     */
    public Integer lun() {
        return this.lun;
    }

    /**
     * Set the lun property: The logical unit number of the data disk. This value is used to identify data disks within
     * the VM and therefore must be unique for each data disk attached to a VM. If not specified, lun would be auto
     * assigned.
     * 
     * @param lun the lun value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withLun(Integer lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Get the caching property: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     * **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**.
     * 
     * @return the caching value.
     */
    public CachingTypes caching() {
        return this.caching;
    }

    /**
     * Set the caching property: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     * **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**.
     * 
     * @param caching the caching value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the deleteOption property: Specifies whether data disk should be deleted or detached upon VM deletion.
     * Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.**
     * If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     * 
     * @return the deleteOption value.
     */
    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    /**
     * Set the deleteOption property: Specifies whether data disk should be deleted or detached upon VM deletion.
     * Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.**
     * If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     * 
     * @param deleteOption the deleteOption value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    /**
     * Get the diskEncryptionSet property: Specifies the customer managed disk encryption set resource id for the
     * managed disk.
     * 
     * @return the diskEncryptionSet value.
     */
    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    /**
     * Set the diskEncryptionSet property: Specifies the customer managed disk encryption set resource id for the
     * managed disk.
     * 
     * @param diskEncryptionSet the diskEncryptionSet value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    /**
     * Get the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on
     * the disk.
     * 
     * @return the writeAcceleratorEnabled value.
     */
    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    /**
     * Set the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on
     * the disk.
     * 
     * @param writeAcceleratorEnabled the writeAcceleratorEnabled value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskId() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property diskId in model DataDisksToAttach"));
        }
        if (diskEncryptionSet() != null) {
            diskEncryptionSet().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToAttach.class);
}
