// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Specifies the input for attaching and detaching a list of managed data disks.
 */
@Fluent
public final class AttachDetachDataDisksRequest {
    /*
     * The list of managed data disks to be attached.
     */
    @JsonProperty(value = "dataDisksToAttach")
    private List<DataDisksToAttach> dataDisksToAttach;

    /*
     * The list of managed data disks to be detached.
     */
    @JsonProperty(value = "dataDisksToDetach")
    private List<DataDisksToDetach> dataDisksToDetach;

    /**
     * Creates an instance of AttachDetachDataDisksRequest class.
     */
    public AttachDetachDataDisksRequest() {
    }

    /**
     * Get the dataDisksToAttach property: The list of managed data disks to be attached.
     * 
     * @return the dataDisksToAttach value.
     */
    public List<DataDisksToAttach> dataDisksToAttach() {
        return this.dataDisksToAttach;
    }

    /**
     * Set the dataDisksToAttach property: The list of managed data disks to be attached.
     * 
     * @param dataDisksToAttach the dataDisksToAttach value to set.
     * @return the AttachDetachDataDisksRequest object itself.
     */
    public AttachDetachDataDisksRequest withDataDisksToAttach(List<DataDisksToAttach> dataDisksToAttach) {
        this.dataDisksToAttach = dataDisksToAttach;
        return this;
    }

    /**
     * Get the dataDisksToDetach property: The list of managed data disks to be detached.
     * 
     * @return the dataDisksToDetach value.
     */
    public List<DataDisksToDetach> dataDisksToDetach() {
        return this.dataDisksToDetach;
    }

    /**
     * Set the dataDisksToDetach property: The list of managed data disks to be detached.
     * 
     * @param dataDisksToDetach the dataDisksToDetach value to set.
     * @return the AttachDetachDataDisksRequest object itself.
     */
    public AttachDetachDataDisksRequest withDataDisksToDetach(List<DataDisksToDetach> dataDisksToDetach) {
        this.dataDisksToDetach = dataDisksToDetach;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataDisksToAttach() != null) {
            dataDisksToAttach().forEach(e -> e.validate());
        }
        if (dataDisksToDetach() != null) {
            dataDisksToDetach().forEach(e -> e.validate());
        }
    }
}
