// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * disk encryption set resource update properties.
 */
@Fluent
public final class DiskEncryptionSetUpdateProperties {
    /*
     * The type of key used to encrypt the data of the disk.
     */
    @JsonProperty(value = "encryptionType")
    private DiskEncryptionSetType encryptionType;

    /*
     * Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
     */
    @JsonProperty(value = "activeKey")
    private KeyForDiskEncryptionSet activeKey;

    /*
     * Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
     */
    @JsonProperty(value = "rotationToLatestKeyVersionEnabled")
    private Boolean rotationToLatestKeyVersionEnabled;

    /*
     * Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will
     * clear the property.
     */
    @JsonProperty(value = "federatedClientId")
    private String federatedClientId;

    /**
     * Creates an instance of DiskEncryptionSetUpdateProperties class.
     */
    public DiskEncryptionSetUpdateProperties() {
    }

    /**
     * Get the encryptionType property: The type of key used to encrypt the data of the disk.
     * 
     * @return the encryptionType value.
     */
    public DiskEncryptionSetType encryptionType() {
        return this.encryptionType;
    }

    /**
     * Set the encryptionType property: The type of key used to encrypt the data of the disk.
     * 
     * @param encryptionType the encryptionType value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties withEncryptionType(DiskEncryptionSetType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    /**
     * Get the activeKey property: Key Vault Key Url to be used for server side encryption of Managed Disks and
     * Snapshots.
     * 
     * @return the activeKey value.
     */
    public KeyForDiskEncryptionSet activeKey() {
        return this.activeKey;
    }

    /**
     * Set the activeKey property: Key Vault Key Url to be used for server side encryption of Managed Disks and
     * Snapshots.
     * 
     * @param activeKey the activeKey value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties withActiveKey(KeyForDiskEncryptionSet activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    /**
     * Get the rotationToLatestKeyVersionEnabled property: Set this flag to true to enable auto-updating of this disk
     * encryption set to the latest key version.
     * 
     * @return the rotationToLatestKeyVersionEnabled value.
     */
    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    /**
     * Set the rotationToLatestKeyVersionEnabled property: Set this flag to true to enable auto-updating of this disk
     * encryption set to the latest key version.
     * 
     * @param rotationToLatestKeyVersionEnabled the rotationToLatestKeyVersionEnabled value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties
        withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    /**
     * Get the federatedClientId property: Multi-tenant application client id to access key vault in a different
     * tenant. Setting the value to 'None' will clear the property.
     * 
     * @return the federatedClientId value.
     */
    public String federatedClientId() {
        return this.federatedClientId;
    }

    /**
     * Set the federatedClientId property: Multi-tenant application client id to access key vault in a different
     * tenant. Setting the value to 'None' will clear the property.
     * 
     * @param federatedClientId the federatedClientId value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties withFederatedClientId(String federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (activeKey() != null) {
            activeKey().validate();
        }
    }
}
