// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * OS family properties.
 */
@Immutable
public final class OSFamilyProperties {
    /*
     * The OS family name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The OS family label.
     */
    @JsonProperty(value = "label", access = JsonProperty.Access.WRITE_ONLY)
    private String label;

    /*
     * List of OS versions belonging to this family.
     */
    @JsonProperty(value = "versions", access = JsonProperty.Access.WRITE_ONLY)
    private List<OSVersionPropertiesBase> versions;

    /**
     * Creates an instance of OSFamilyProperties class.
     */
    public OSFamilyProperties() {
    }

    /**
     * Get the name property: The OS family name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the label property: The OS family label.
     * 
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Get the versions property: List of OS versions belonging to this family.
     * 
     * @return the versions value.
     */
    public List<OSVersionPropertiesBase> versions() {
        return this.versions;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (versions() != null) {
            versions().forEach(e -> e.validate());
        }
    }
}
