// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Describes the state of the image.
 */
public final class ImageState extends ExpandableStringEnum<ImageState> {
    /**
     * Static value Active for ImageState.
     */
    public static final ImageState ACTIVE = fromString("Active");

    /**
     * Static value ScheduledForDeprecation for ImageState.
     */
    public static final ImageState SCHEDULED_FOR_DEPRECATION = fromString("ScheduledForDeprecation");

    /**
     * Static value Deprecated for ImageState.
     */
    public static final ImageState DEPRECATED = fromString("Deprecated");

    /**
     * Creates a new instance of ImageState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ImageState() {
    }

    /**
     * Creates or finds a ImageState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ImageState.
     */
    @JsonCreator
    public static ImageState fromString(String name) {
        return fromString(name, ImageState.class);
    }

    /**
     * Gets known ImageState values.
     * 
     * @return known ImageState values.
     */
    public static Collection<ImageState> values() {
        return values(ImageState.class);
    }
}
