// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the parameters of ephemeral disk settings that can be specified for operating system disk. **Note:** The
 * ephemeral disk settings can only be specified for managed disk.
 */
@Fluent
public final class DiffDiskSettings {
    /*
     * Specifies the ephemeral disk settings for operating system disk.
     */
    @JsonProperty(value = "option")
    private DiffDiskOptions option;

    /*
     * Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,**
     * **ResourceDisk,** **NvmeDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size
     * otherwise **ResourceDisk** or **NvmeDisk** is used. Refer to the VM size documentation for Windows VM at
     * https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     * https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     * Minimum api-version for NvmeDisk: 2024-03-01.
     */
    @JsonProperty(value = "placement")
    private DiffDiskPlacement placement;

    /**
     * Creates an instance of DiffDiskSettings class.
     */
    public DiffDiskSettings() {
    }

    /**
     * Get the option property: Specifies the ephemeral disk settings for operating system disk.
     * 
     * @return the option value.
     */
    public DiffDiskOptions option() {
        return this.option;
    }

    /**
     * Set the option property: Specifies the ephemeral disk settings for operating system disk.
     * 
     * @param option the option value to set.
     * @return the DiffDiskSettings object itself.
     */
    public DiffDiskSettings withOption(DiffDiskOptions option) {
        this.option = option;
        return this;
    }

    /**
     * Get the placement property: Specifies the ephemeral disk placement for operating system disk. Possible values
     * are: **CacheDisk,** **ResourceDisk,** **NvmeDisk.** The defaulting behavior is: **CacheDisk** if one is
     * configured for the VM size otherwise **ResourceDisk** or **NvmeDisk** is used. Refer to the VM size
     * documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     * https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     * Minimum api-version for NvmeDisk: 2024-03-01.
     * 
     * @return the placement value.
     */
    public DiffDiskPlacement placement() {
        return this.placement;
    }

    /**
     * Set the placement property: Specifies the ephemeral disk placement for operating system disk. Possible values
     * are: **CacheDisk,** **ResourceDisk,** **NvmeDisk.** The defaulting behavior is: **CacheDisk** if one is
     * configured for the VM size otherwise **ResourceDisk** or **NvmeDisk** is used. Refer to the VM size
     * documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     * https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     * Minimum api-version for NvmeDisk: 2024-03-01.
     * 
     * @param placement the placement value to set.
     * @return the DiffDiskSettings object itself.
     */
    public DiffDiskSettings withPlacement(DiffDiskPlacement placement) {
        this.placement = placement;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
