// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role
 * instance.
 */
@Fluent
public final class CloudServiceVaultAndSecretReference {
    /*
     * The ARM Resource ID of the Key Vault
     */
    @JsonProperty(value = "sourceVault")
    private SubResource sourceVault;

    /*
     * Secret URL which contains the protected settings of the extension
     */
    @JsonProperty(value = "secretUrl")
    private String secretUrl;

    /**
     * Creates an instance of CloudServiceVaultAndSecretReference class.
     */
    public CloudServiceVaultAndSecretReference() {
    }

    /**
     * Get the sourceVault property: The ARM Resource ID of the Key Vault.
     * 
     * @return the sourceVault value.
     */
    public SubResource sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: The ARM Resource ID of the Key Vault.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the CloudServiceVaultAndSecretReference object itself.
     */
    public CloudServiceVaultAndSecretReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the secretUrl property: Secret URL which contains the protected settings of the extension.
     * 
     * @return the secretUrl value.
     */
    public String secretUrl() {
        return this.secretUrl;
    }

    /**
     * Set the secretUrl property: Secret URL which contains the protected settings of the extension.
     * 
     * @param secretUrl the secretUrl value to set.
     * @return the CloudServiceVaultAndSecretReference object itself.
     */
    public CloudServiceVaultAndSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
