// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.compute.fluent.CloudServiceOperatingSystemsClient;
import com.azure.resourcemanager.compute.fluent.models.OSFamilyInner;
import com.azure.resourcemanager.compute.fluent.models.OSVersionInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.OSFamilyListResult;
import com.azure.resourcemanager.compute.models.OSVersionListResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CloudServiceOperatingSystemsClient.
 */
public final class CloudServiceOperatingSystemsClientImpl implements CloudServiceOperatingSystemsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CloudServiceOperatingSystemsService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of CloudServiceOperatingSystemsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CloudServiceOperatingSystemsClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(CloudServiceOperatingSystemsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientCloudServiceOperatingSystems to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    public interface CloudServiceOperatingSystemsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsVersions/{osVersionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<OSVersionInner>> getOSVersion(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @PathParam("osVersionName") String osVersionName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsVersions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<OSVersionListResult>> listOSVersions(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsFamilies/{osFamilyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<OSFamilyInner>> getOSFamily(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @PathParam("osFamilyName") String osFamilyName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsFamilies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<OSFamilyListResult>> listOSFamilies(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<OSVersionListResult>> listOSVersionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<OSFamilyListResult>> listOSFamiliesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS version pertains to.
     * @param osVersionName Name of the OS version.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OSVersionInner>> getOSVersionWithResponseAsync(String location, String osVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osVersionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter osVersionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getOSVersion(this.client.getEndpoint(), location, osVersionName,
                this.client.getSubscriptionId(), apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS version pertains to.
     * @param osVersionName Name of the OS version.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<OSVersionInner>> getOSVersionWithResponseAsync(String location, String osVersionName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osVersionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter osVersionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getOSVersion(this.client.getEndpoint(), location, osVersionName, this.client.getSubscriptionId(),
            apiVersion, accept, context);
    }

    /**
     * Gets properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS version pertains to.
     * @param osVersionName Name of the OS version.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OSVersionInner> getOSVersionAsync(String location, String osVersionName) {
        return getOSVersionWithResponseAsync(location, osVersionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS version pertains to.
     * @param osVersionName Name of the OS version.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<OSVersionInner> getOSVersionWithResponse(String location, String osVersionName, Context context) {
        return getOSVersionWithResponseAsync(location, osVersionName, context).block();
    }

    /**
     * Gets properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS version pertains to.
     * @param osVersionName Name of the OS version.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system version that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OSVersionInner getOSVersion(String location, String osVersionName) {
        return getOSVersionWithResponse(location, osVersionName, Context.NONE).getValue();
    }

    /**
     * Gets a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS versions. Do this
     * till nextLink is null to fetch all the OS versions.
     * 
     * @param location Name of the location that the OS versions pertain to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOSVersions(this.client.getEndpoint(), location,
                this.client.getSubscriptionId(), apiVersion, accept, context))
            .<PagedResponse<OSVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS versions. Do this
     * till nextLink is null to fetch all the OS versions.
     * 
     * @param location Name of the location that the OS versions pertain to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listOSVersions(this.client.getEndpoint(), location, this.client.getSubscriptionId(), apiVersion, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS versions. Do this
     * till nextLink is null to fetch all the OS versions.
     * 
     * @param location Name of the location that the OS versions pertain to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<OSVersionInner> listOSVersionsAsync(String location) {
        return new PagedFlux<>(() -> listOSVersionsSinglePageAsync(location),
            nextLink -> listOSVersionsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS versions. Do this
     * till nextLink is null to fetch all the OS versions.
     * 
     * @param location Name of the location that the OS versions pertain to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<OSVersionInner> listOSVersionsAsync(String location, Context context) {
        return new PagedFlux<>(() -> listOSVersionsSinglePageAsync(location, context),
            nextLink -> listOSVersionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS versions. Do this
     * till nextLink is null to fetch all the OS versions.
     * 
     * @param location Name of the location that the OS versions pertain to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<OSVersionInner> listOSVersions(String location) {
        return new PagedIterable<>(listOSVersionsAsync(location));
    }

    /**
     * Gets a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS versions. Do this
     * till nextLink is null to fetch all the OS versions.
     * 
     * @param location Name of the location that the OS versions pertain to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system versions available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<OSVersionInner> listOSVersions(String location, Context context) {
        return new PagedIterable<>(listOSVersionsAsync(location, context));
    }

    /**
     * Gets properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS family pertains to.
     * @param osFamilyName Name of the OS family.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OSFamilyInner>> getOSFamilyWithResponseAsync(String location, String osFamilyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osFamilyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter osFamilyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getOSFamily(this.client.getEndpoint(), location, osFamilyName,
                this.client.getSubscriptionId(), apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS family pertains to.
     * @param osFamilyName Name of the OS family.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<OSFamilyInner>> getOSFamilyWithResponseAsync(String location, String osFamilyName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osFamilyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter osFamilyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getOSFamily(this.client.getEndpoint(), location, osFamilyName, this.client.getSubscriptionId(),
            apiVersion, accept, context);
    }

    /**
     * Gets properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS family pertains to.
     * @param osFamilyName Name of the OS family.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OSFamilyInner> getOSFamilyAsync(String location, String osFamilyName) {
        return getOSFamilyWithResponseAsync(location, osFamilyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS family pertains to.
     * @param osFamilyName Name of the OS family.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<OSFamilyInner> getOSFamilyWithResponse(String location, String osFamilyName, Context context) {
        return getOSFamilyWithResponseAsync(location, osFamilyName, context).block();
    }

    /**
     * Gets properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     * 
     * @param location Name of the location that the OS family pertains to.
     * @param osFamilyName Name of the OS family.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a guest operating system family that can be specified in the XML service configuration
     * (.cscfg) for a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OSFamilyInner getOSFamily(String location, String osFamilyName) {
        return getOSFamilyWithResponse(location, osFamilyName, Context.NONE).getValue();
    }

    /**
     * Gets a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS Families. Do this
     * till nextLink is null to fetch all the OS Families.
     * 
     * @param location Name of the location that the OS families pertain to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOSFamilies(this.client.getEndpoint(), location,
                this.client.getSubscriptionId(), apiVersion, accept, context))
            .<PagedResponse<OSFamilyInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS Families. Do this
     * till nextLink is null to fetch all the OS Families.
     * 
     * @param location Name of the location that the OS families pertain to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-09-04";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listOSFamilies(this.client.getEndpoint(), location, this.client.getSubscriptionId(), apiVersion, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS Families. Do this
     * till nextLink is null to fetch all the OS Families.
     * 
     * @param location Name of the location that the OS families pertain to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<OSFamilyInner> listOSFamiliesAsync(String location) {
        return new PagedFlux<>(() -> listOSFamiliesSinglePageAsync(location),
            nextLink -> listOSFamiliesNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS Families. Do this
     * till nextLink is null to fetch all the OS Families.
     * 
     * @param location Name of the location that the OS families pertain to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<OSFamilyInner> listOSFamiliesAsync(String location, Context context) {
        return new PagedFlux<>(() -> listOSFamiliesSinglePageAsync(location, context),
            nextLink -> listOSFamiliesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS Families. Do this
     * till nextLink is null to fetch all the OS Families.
     * 
     * @param location Name of the location that the OS families pertain to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<OSFamilyInner> listOSFamilies(String location) {
        return new PagedIterable<>(listOSFamiliesAsync(location));
    }

    /**
     * Gets a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service. Use nextLink property in the response to get the next page of OS Families. Do this
     * till nextLink is null to fetch all the OS Families.
     * 
     * @param location Name of the location that the OS families pertain to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all guest operating system families available to be specified in the XML service configuration
     * (.cscfg) for a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<OSFamilyInner> listOSFamilies(String location, Context context) {
        return new PagedIterable<>(listOSFamiliesAsync(location, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list operation result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOSVersionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<OSVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list operation result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listOSVersionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list operation result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOSFamiliesNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<OSFamilyInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list operation result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listOSFamiliesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
