// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.models.CommunityGalleryMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Describes the properties of a community gallery.
 */
@Fluent
public final class CommunityGalleryProperties {
    /*
     * The disclaimer for a community gallery resource.
     */
    @JsonProperty(value = "disclaimer")
    private String disclaimer;

    /*
     * The artifact tags of a community gallery resource.
     */
    @JsonProperty(value = "artifactTags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> artifactTags;

    /*
     * The metadata of community gallery.
     */
    @JsonProperty(value = "communityMetadata")
    private CommunityGalleryMetadata communityMetadata;

    /**
     * Creates an instance of CommunityGalleryProperties class.
     */
    public CommunityGalleryProperties() {
    }

    /**
     * Get the disclaimer property: The disclaimer for a community gallery resource.
     * 
     * @return the disclaimer value.
     */
    public String disclaimer() {
        return this.disclaimer;
    }

    /**
     * Set the disclaimer property: The disclaimer for a community gallery resource.
     * 
     * @param disclaimer the disclaimer value to set.
     * @return the CommunityGalleryProperties object itself.
     */
    public CommunityGalleryProperties withDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
        return this;
    }

    /**
     * Get the artifactTags property: The artifact tags of a community gallery resource.
     * 
     * @return the artifactTags value.
     */
    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    /**
     * Set the artifactTags property: The artifact tags of a community gallery resource.
     * 
     * @param artifactTags the artifactTags value to set.
     * @return the CommunityGalleryProperties object itself.
     */
    public CommunityGalleryProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    /**
     * Get the communityMetadata property: The metadata of community gallery.
     * 
     * @return the communityMetadata value.
     */
    public CommunityGalleryMetadata communityMetadata() {
        return this.communityMetadata;
    }

    /**
     * Set the communityMetadata property: The metadata of community gallery.
     * 
     * @param communityMetadata the communityMetadata value to set.
     * @return the CommunityGalleryProperties object itself.
     */
    public CommunityGalleryProperties withCommunityMetadata(CommunityGalleryMetadata communityMetadata) {
        this.communityMetadata = communityMetadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (communityMetadata() != null) {
            communityMetadata().validate();
        }
    }
}
