// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.RetrieveBootDiagnosticsDataResultInner;
import com.azure.resourcemanager.compute.fluent.models.RunCommandResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineAssessPatchesResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineCaptureResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstallPatchesResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineUpdateInner;
import com.azure.resourcemanager.compute.models.AttachDetachDataDisksRequest;
import com.azure.resourcemanager.compute.models.ExpandTypeForListVMs;
import com.azure.resourcemanager.compute.models.ExpandTypesForListVMs;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.RunCommandInput;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineCaptureParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineInstallPatchesParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineReimageParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in VirtualMachinesClient.
 */
public interface VirtualMachinesClient extends InnerSupportsGet<VirtualMachineInner>,
    InnerSupportsListing<VirtualMachineInner>, InnerSupportsDelete<Void> {
    /**
     * Gets all the virtual machines under the specified subscription for the specified location.
     * 
     * @param location The location for which virtual machines under the subscription are queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the virtual machines under the specified subscription for the specified location as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineInner> listByLocationAsync(String location);

    /**
     * Gets all the virtual machines under the specified subscription for the specified location.
     * 
     * @param location The location for which virtual machines under the subscription are queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the virtual machines under the specified subscription for the specified location as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineInner> listByLocation(String location);

    /**
     * Gets all the virtual machines under the specified subscription for the specified location.
     * 
     * @param location The location for which virtual machines under the subscription are queried.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the virtual machines under the specified subscription for the specified location as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineInner> listByLocation(String location, Context context);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of virtual machine capture operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> captureWithResponseAsync(String resourceGroupName, String vmName,
        VirtualMachineCaptureParameters parameters);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of output of virtual machine capture operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner>
        beginCaptureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of output of virtual machine capture operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner>
        beginCapture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of output of virtual machine capture operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner> beginCapture(
        String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters, Context context);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of virtual machine capture operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineCaptureResultInner> captureAsync(String resourceGroupName, String vmName,
        VirtualMachineCaptureParameters parameters);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of virtual machine capture operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineCaptureResultInner capture(String resourceGroupName, String vmName,
        VirtualMachineCaptureParameters parameters);

    /**
     * Captures the VM by copying virtual hard disks of the VM and outputs a template that can be used to create similar
     * VMs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Capture Virtual Machine operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of virtual machine capture operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineCaptureResultInner capture(String resourceGroupName, String vmName,
        VirtualMachineCaptureParameters parameters, Context context);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName,
        VirtualMachineInner parameters, String ifMatch, String ifNoneMatch);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String vmName, VirtualMachineInner parameters, String ifMatch, String ifNoneMatch);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String vmName, VirtualMachineInner parameters);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdate(String resourceGroupName,
        String vmName, VirtualMachineInner parameters);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdate(String resourceGroupName,
        String vmName, VirtualMachineInner parameters, String ifMatch, String ifNoneMatch, Context context);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInner> createOrUpdateAsync(String resourceGroupName, String vmName,
        VirtualMachineInner parameters, String ifMatch, String ifNoneMatch);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInner> createOrUpdateAsync(String resourceGroupName, String vmName,
        VirtualMachineInner parameters);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInner createOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters);

    /**
     * The operation to create or update a virtual machine. Please note some properties can be set only during virtual
     * machine creation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Create Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInner createOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters,
        String ifMatch, String ifNoneMatch, Context context);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName,
        VirtualMachineUpdateInner parameters, String ifMatch, String ifNoneMatch);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdateAsync(String resourceGroupName,
        String vmName, VirtualMachineUpdateInner parameters, String ifMatch, String ifNoneMatch);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdateAsync(String resourceGroupName,
        String vmName, VirtualMachineUpdateInner parameters);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdate(String resourceGroupName,
        String vmName, VirtualMachineUpdateInner parameters);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdate(String resourceGroupName,
        String vmName, VirtualMachineUpdateInner parameters, String ifMatch, String ifNoneMatch, Context context);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInner> updateAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters,
        String ifMatch, String ifNoneMatch);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInner> updateAsync(String resourceGroupName, String vmName,
        VirtualMachineUpdateInner parameters);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInner update(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters);

    /**
     * The operation to update a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Update Virtual Machine operation.
     * @param ifMatch The ETag of the transformation. Omit this value to always overwrite the current resource. Specify
     * the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     * set. Other values will result in error from server as they are not supported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInner update(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters,
        String ifMatch, String ifNoneMatch, Context context);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param forceDeletion Optional parameter to force delete virtual machines.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName,
        Boolean forceDeletion);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param forceDeletion Optional parameter to force delete virtual machines.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName, Boolean forceDeletion);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param forceDeletion Optional parameter to force delete virtual machines.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, Boolean forceDeletion,
        Context context);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param forceDeletion Optional parameter to force delete virtual machines.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String vmName, Boolean forceDeletion);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String vmName);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String vmName);

    /**
     * The operation to delete a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param forceDeletion Optional parameter to force delete virtual machines.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String vmName, Boolean forceDeletion, Context context);

    /**
     * Retrieves information about the model view or the instance view of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param expand The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime
     * properties of the virtual machine that is managed by the platform and can change outside of control plane
     * operations. 'UserData' retrieves the UserData property as part of the VM model view that was provided by the user
     * during the VM Create/Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VirtualMachineInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vmName,
        InstanceViewTypes expand);

    /**
     * Retrieves information about the model view or the instance view of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName);

    /**
     * Retrieves information about the model view or the instance view of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param expand The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime
     * properties of the virtual machine that is managed by the platform and can change outside of control plane
     * operations. 'UserData' retrieves the UserData property as part of the VM model view that was provided by the user
     * during the VM Create/Update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VirtualMachineInner> getByResourceGroupWithResponse(String resourceGroupName, String vmName,
        InstanceViewTypes expand, Context context);

    /**
     * Retrieves information about the model view or the instance view of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInner getByResourceGroup(String resourceGroupName, String vmName);

    /**
     * Retrieves information about the run-time state of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of a virtual machine along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VirtualMachineInstanceViewInner>> instanceViewWithResponseAsync(String resourceGroupName,
        String vmName);

    /**
     * Retrieves information about the run-time state of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of a virtual machine on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInstanceViewInner> instanceViewAsync(String resourceGroupName, String vmName);

    /**
     * Retrieves information about the run-time state of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of a virtual machine along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VirtualMachineInstanceViewInner> instanceViewWithResponse(String resourceGroupName, String vmName,
        Context context);

    /**
     * Retrieves information about the run-time state of a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of a virtual machine.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInstanceViewInner instanceView(String resourceGroupName, String vmName);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> convertToManagedDisksWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginConvertToManagedDisksAsync(String resourceGroupName, String vmName);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginConvertToManagedDisks(String resourceGroupName, String vmName);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginConvertToManagedDisks(String resourceGroupName, String vmName,
        Context context);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> convertToManagedDisksAsync(String resourceGroupName, String vmName);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void convertToManagedDisks(String resourceGroupName, String vmName);

    /**
     * Converts virtual machine disks from blob-based to managed disks. Virtual machine must be stop-deallocated before
     * invoking this operation.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void convertToManagedDisks(String resourceGroupName, String vmName, Context context);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param hibernate Optional parameter to hibernate a virtual machine. (Feature in Preview).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmName,
        Boolean hibernate);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param hibernate Optional parameter to hibernate a virtual machine. (Feature in Preview).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmName, Boolean hibernate);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param hibernate Optional parameter to hibernate a virtual machine. (Feature in Preview).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmName, Boolean hibernate,
        Context context);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param hibernate Optional parameter to hibernate a virtual machine. (Feature in Preview).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deallocateAsync(String resourceGroupName, String vmName, Boolean hibernate);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deallocateAsync(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deallocate(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine and releases the compute resources. You are not billed for the compute resources
     * that this virtual machine uses.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param hibernate Optional parameter to hibernate a virtual machine. (Feature in Preview).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deallocate(String resourceGroupName, String vmName, Boolean hibernate, Context context);

    /**
     * Sets the OS state of the virtual machine to generalized. It is recommended to sysprep the virtual machine before
     * performing this operation. For Windows, please refer to [Create a managed image of a generalized VM in
     * Azure](https://docs.microsoft.com/azure/virtual-machines/windows/capture-image-resource). For Linux, please refer
     * to [How to create an image of a virtual machine or
     * VHD](https://docs.microsoft.com/azure/virtual-machines/linux/capture-image).
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> generalizeWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * Sets the OS state of the virtual machine to generalized. It is recommended to sysprep the virtual machine before
     * performing this operation. For Windows, please refer to [Create a managed image of a generalized VM in
     * Azure](https://docs.microsoft.com/azure/virtual-machines/windows/capture-image-resource). For Linux, please refer
     * to [How to create an image of a virtual machine or
     * VHD](https://docs.microsoft.com/azure/virtual-machines/linux/capture-image).
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> generalizeAsync(String resourceGroupName, String vmName);

    /**
     * Sets the OS state of the virtual machine to generalized. It is recommended to sysprep the virtual machine before
     * performing this operation. For Windows, please refer to [Create a managed image of a generalized VM in
     * Azure](https://docs.microsoft.com/azure/virtual-machines/windows/capture-image-resource). For Linux, please refer
     * to [How to create an image of a virtual machine or
     * VHD](https://docs.microsoft.com/azure/virtual-machines/linux/capture-image).
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> generalizeWithResponse(String resourceGroupName, String vmName, Context context);

    /**
     * Sets the OS state of the virtual machine to generalized. It is recommended to sysprep the virtual machine before
     * performing this operation. For Windows, please refer to [Create a managed image of a generalized VM in
     * Azure](https://docs.microsoft.com/azure/virtual-machines/windows/capture-image-resource). For Linux, please refer
     * to [How to create an image of a virtual machine or
     * VHD](https://docs.microsoft.com/azure/virtual-machines/linux/capture-image).
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void generalize(String resourceGroupName, String vmName);

    /**
     * Lists all of the virtual machines in the specified resource group. Use the nextLink property in the response to
     * get the next page of virtual machines.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param filter The system query option to filter VMs returned in the response. Allowed value is
     * 'virtualMachineScaleSet/id' eq
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}'.
     * @param expand The expand expression to apply on operation. 'instanceView' enables fetching run time status of all
     * Virtual Machines, this can only be specified if a valid $filter option is specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineInner> listByResourceGroupAsync(String resourceGroupName, String filter,
        ExpandTypeForListVMs expand);

    /**
     * Lists all of the virtual machines in the specified resource group. Use the nextLink property in the response to
     * get the next page of virtual machines.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all of the virtual machines in the specified resource group. Use the nextLink property in the response to
     * get the next page of virtual machines.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all of the virtual machines in the specified resource group. Use the nextLink property in the response to
     * get the next page of virtual machines.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param filter The system query option to filter VMs returned in the response. Allowed value is
     * 'virtualMachineScaleSet/id' eq
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}'.
     * @param expand The expand expression to apply on operation. 'instanceView' enables fetching run time status of all
     * Virtual Machines, this can only be specified if a valid $filter option is specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineInner> listByResourceGroup(String resourceGroupName, String filter,
        ExpandTypeForListVMs expand, Context context);

    /**
     * Lists all of the virtual machines in the specified subscription. Use the nextLink property in the response to get
     * the next page of virtual machines.
     * 
     * @param statusOnly statusOnly=true enables fetching run time status of all Virtual Machines in the subscription.
     * @param filter The system query option to filter VMs returned in the response. Allowed value is
     * 'virtualMachineScaleSet/id' eq
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}'.
     * @param expand The expand expression to apply on operation. 'instanceView' enables fetching run time status of all
     * Virtual Machines, this can only be specified if a valid $filter option is specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineInner> listAsync(String statusOnly, String filter, ExpandTypesForListVMs expand);

    /**
     * Lists all of the virtual machines in the specified subscription. Use the nextLink property in the response to get
     * the next page of virtual machines.
     * 
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineInner> listAsync();

    /**
     * Lists all of the virtual machines in the specified subscription. Use the nextLink property in the response to get
     * the next page of virtual machines.
     * 
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineInner> list();

    /**
     * Lists all of the virtual machines in the specified subscription. Use the nextLink property in the response to get
     * the next page of virtual machines.
     * 
     * @param statusOnly statusOnly=true enables fetching run time status of all Virtual Machines in the subscription.
     * @param filter The system query option to filter VMs returned in the response. Allowed value is
     * 'virtualMachineScaleSet/id' eq
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}'.
     * @param expand The expand expression to apply on operation. 'instanceView' enables fetching run time status of all
     * Virtual Machines, this can only be specified if a valid $filter option is specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineInner> list(String statusOnly, String filter, ExpandTypesForListVMs expand,
        Context context);

    /**
     * Lists all available virtual machine sizes to which the specified virtual machine can be resized.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineSizeInner> listAvailableSizesAsync(String resourceGroupName, String vmName);

    /**
     * Lists all available virtual machine sizes to which the specified virtual machine can be resized.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String vmName);

    /**
     * Lists all available virtual machine sizes to which the specified virtual machine can be resized.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param skipShutdown The parameter to request non-graceful VM shutdown. True value for this flag indicates
     * non-graceful shutdown whereas false indicates otherwise. Default value for this flag is false if not specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmName,
        Boolean skipShutdown);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param skipShutdown The parameter to request non-graceful VM shutdown. True value for this flag indicates
     * non-graceful shutdown whereas false indicates otherwise. Default value for this flag is false if not specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmName,
        Boolean skipShutdown);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmName);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmName);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param skipShutdown The parameter to request non-graceful VM shutdown. True value for this flag indicates
     * non-graceful shutdown whereas false indicates otherwise. Default value for this flag is false if not specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmName, Boolean skipShutdown,
        Context context);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param skipShutdown The parameter to request non-graceful VM shutdown. True value for this flag indicates
     * non-graceful shutdown whereas false indicates otherwise. Default value for this flag is false if not specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> powerOffAsync(String resourceGroupName, String vmName, Boolean skipShutdown);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> powerOffAsync(String resourceGroupName, String vmName);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void powerOff(String resourceGroupName, String vmName);

    /**
     * The operation to power off (stop) a virtual machine. The virtual machine can be restarted with the same
     * provisioned resources. You are still charged for this virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param skipShutdown The parameter to request non-graceful VM shutdown. True value for this flag indicates
     * non-graceful shutdown whereas false indicates otherwise. Default value for this flag is false if not specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void powerOff(String resourceGroupName, String vmName, Boolean skipShutdown, Context context);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> reapplyWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginReapplyAsync(String resourceGroupName, String vmName);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReapply(String resourceGroupName, String vmName);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReapply(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> reapplyAsync(String resourceGroupName, String vmName);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reapply(String resourceGroupName, String vmName);

    /**
     * The operation to reapply a virtual machine's state.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reapply(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmName);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmName);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartAsync(String resourceGroupName, String vmName);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restart(String resourceGroupName, String vmName);

    /**
     * The operation to restart a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restart(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmName);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmName);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> startAsync(String resourceGroupName, String vmName);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void start(String resourceGroupName, String vmName);

    /**
     * The operation to start a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void start(String resourceGroupName, String vmName, Context context);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmName, Context context);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> redeployAsync(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void redeploy(String resourceGroupName, String vmName);

    /**
     * Shuts down the virtual machine, moves it to a new node, and powers it back on.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void redeploy(String resourceGroupName, String vmName, Context context);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Reimage Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmName,
        VirtualMachineReimageParameters parameters);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Reimage Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmName,
        VirtualMachineReimageParameters parameters);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmName);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmName);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Reimage Virtual Machine operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmName,
        VirtualMachineReimageParameters parameters, Context context);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Reimage Virtual Machine operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> reimageAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> reimageAsync(String resourceGroupName, String vmName);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reimage(String resourceGroupName, String vmName);

    /**
     * Reimages (upgrade the operating system) a virtual machine which don't have a ephemeral OS disk, for virtual
     * machines who have a ephemeral OS disk the virtual machine is reset to initial state. NOTE: The retaining of old
     * OS disk depends on the value of deleteOption of OS disk. If deleteOption is detach, the old OS disk will be
     * preserved after reimage. If deleteOption is delete, the old OS disk will be deleted after reimage. The
     * deleteOption of the OS disk should be updated accordingly before performing the reimage.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Reimage Virtual Machine operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reimage(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters, Context context);

    /**
     * The operation to retrieve SAS URIs for a virtual machine's boot diagnostic logs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param sasUriExpirationTimeInMinutes Expiration duration in minutes for the SAS URIs with a value between 1 to
     * 1440 minutes. **Note:** If not specified, SAS URIs will be generated with a default expiration duration of 120
     * minutes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SAS URIs of the console screenshot and serial log blobs along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RetrieveBootDiagnosticsDataResultInner>> retrieveBootDiagnosticsDataWithResponseAsync(
        String resourceGroupName, String vmName, Integer sasUriExpirationTimeInMinutes);

    /**
     * The operation to retrieve SAS URIs for a virtual machine's boot diagnostic logs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SAS URIs of the console screenshot and serial log blobs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RetrieveBootDiagnosticsDataResultInner> retrieveBootDiagnosticsDataAsync(String resourceGroupName,
        String vmName);

    /**
     * The operation to retrieve SAS URIs for a virtual machine's boot diagnostic logs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param sasUriExpirationTimeInMinutes Expiration duration in minutes for the SAS URIs with a value between 1 to
     * 1440 minutes. **Note:** If not specified, SAS URIs will be generated with a default expiration duration of 120
     * minutes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SAS URIs of the console screenshot and serial log blobs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RetrieveBootDiagnosticsDataResultInner> retrieveBootDiagnosticsDataWithResponse(String resourceGroupName,
        String vmName, Integer sasUriExpirationTimeInMinutes, Context context);

    /**
     * The operation to retrieve SAS URIs for a virtual machine's boot diagnostic logs.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SAS URIs of the console screenshot and serial log blobs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RetrieveBootDiagnosticsDataResultInner retrieveBootDiagnosticsData(String resourceGroupName, String vmName);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmName);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmName);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmName,
        Context context);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmName);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void performMaintenance(String resourceGroupName, String vmName);

    /**
     * The operation to perform maintenance on a virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void performMaintenance(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to simulate the eviction of spot virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> simulateEvictionWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * The operation to simulate the eviction of spot virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> simulateEvictionAsync(String resourceGroupName, String vmName);

    /**
     * The operation to simulate the eviction of spot virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> simulateEvictionWithResponse(String resourceGroupName, String vmName, Context context);

    /**
     * The operation to simulate the eviction of spot virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void simulateEviction(String resourceGroupName, String vmName);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the properties of an AssessPatches result along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> assessPatchesWithResponseAsync(String resourceGroupName, String vmName);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes the properties of an AssessPatches result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner>
        beginAssessPatchesAsync(String resourceGroupName, String vmName);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes the properties of an AssessPatches result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner>
        beginAssessPatches(String resourceGroupName, String vmName);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes the properties of an AssessPatches result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner>
        beginAssessPatches(String resourceGroupName, String vmName, Context context);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the properties of an AssessPatches result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineAssessPatchesResultInner> assessPatchesAsync(String resourceGroupName, String vmName);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the properties of an AssessPatches result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineAssessPatchesResultInner assessPatches(String resourceGroupName, String vmName);

    /**
     * Assess patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the properties of an AssessPatches result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineAssessPatchesResultInner assessPatches(String resourceGroupName, String vmName, Context context);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result summary of an installation operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> installPatchesWithResponseAsync(String resourceGroupName, String vmName,
        VirtualMachineInstallPatchesParameters installPatchesInput);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result summary of an installation operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner>
        beginInstallPatchesAsync(String resourceGroupName, String vmName,
            VirtualMachineInstallPatchesParameters installPatchesInput);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result summary of an installation operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner>
        beginInstallPatches(String resourceGroupName, String vmName,
            VirtualMachineInstallPatchesParameters installPatchesInput);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result summary of an installation operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner>
        beginInstallPatches(String resourceGroupName, String vmName,
            VirtualMachineInstallPatchesParameters installPatchesInput, Context context);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result summary of an installation operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineInstallPatchesResultInner> installPatchesAsync(String resourceGroupName, String vmName,
        VirtualMachineInstallPatchesParameters installPatchesInput);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result summary of an installation operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInstallPatchesResultInner installPatches(String resourceGroupName, String vmName,
        VirtualMachineInstallPatchesParameters installPatchesInput);

    /**
     * Installs patches on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param installPatchesInput Input for InstallPatches as directly received by the API.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result summary of an installation operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineInstallPatchesResultInner installPatches(String resourceGroupName, String vmName,
        VirtualMachineInstallPatchesParameters installPatchesInput, Context context);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies the storage settings for the virtual machine disks along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> attachDetachDataDisksWithResponseAsync(String resourceGroupName, String vmName,
        AttachDetachDataDisksRequest parameters);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies the storage settings for the virtual machine disks.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<StorageProfile>, StorageProfile> beginAttachDetachDataDisksAsync(String resourceGroupName,
        String vmName, AttachDetachDataDisksRequest parameters);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies the storage settings for the virtual machine disks.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageProfile>, StorageProfile> beginAttachDetachDataDisks(String resourceGroupName,
        String vmName, AttachDetachDataDisksRequest parameters);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies the storage settings for the virtual machine disks.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageProfile>, StorageProfile> beginAttachDetachDataDisks(String resourceGroupName,
        String vmName, AttachDetachDataDisksRequest parameters, Context context);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies the storage settings for the virtual machine disks on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageProfile> attachDetachDataDisksAsync(String resourceGroupName, String vmName,
        AttachDetachDataDisksRequest parameters);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies the storage settings for the virtual machine disks.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageProfile attachDetachDataDisks(String resourceGroupName, String vmName,
        AttachDetachDataDisksRequest parameters);

    /**
     * Attach and detach data disks to/from the virtual machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the attach and detach data disks operation on the virtual machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies the storage settings for the virtual machine disks.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageProfile attachDetachDataDisks(String resourceGroupName, String vmName,
        AttachDetachDataDisksRequest parameters, Context context);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String vmName,
        RunCommandInput parameters);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommandAsync(String resourceGroupName,
        String vmName, RunCommandInput parameters);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommand(String resourceGroupName,
        String vmName, RunCommandInput parameters);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommand(String resourceGroupName,
        String vmName, RunCommandInput parameters, Context context);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RunCommandResultInner> runCommandAsync(String resourceGroupName, String vmName, RunCommandInput parameters);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunCommandResultInner runCommand(String resourceGroupName, String vmName, RunCommandInput parameters);

    /**
     * Run command on the VM.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine.
     * @param parameters Parameters supplied to the Run command operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunCommandResultInner runCommand(String resourceGroupName, String vmName, RunCommandInput parameters,
        Context context);
}
