// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This is the community gallery image definition identifier.
 */
@Fluent
public final class CommunityGalleryImageIdentifier {
    /*
     * The name of the gallery image definition publisher.
     */
    @JsonProperty(value = "publisher")
    private String publisher;

    /*
     * The name of the gallery image definition offer.
     */
    @JsonProperty(value = "offer")
    private String offer;

    /*
     * The name of the gallery image definition SKU.
     */
    @JsonProperty(value = "sku")
    private String sku;

    /**
     * Creates an instance of CommunityGalleryImageIdentifier class.
     */
    public CommunityGalleryImageIdentifier() {
    }

    /**
     * Get the publisher property: The name of the gallery image definition publisher.
     * 
     * @return the publisher value.
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the publisher property: The name of the gallery image definition publisher.
     * 
     * @param publisher the publisher value to set.
     * @return the CommunityGalleryImageIdentifier object itself.
     */
    public CommunityGalleryImageIdentifier withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the offer property: The name of the gallery image definition offer.
     * 
     * @return the offer value.
     */
    public String offer() {
        return this.offer;
    }

    /**
     * Set the offer property: The name of the gallery image definition offer.
     * 
     * @param offer the offer value to set.
     * @return the CommunityGalleryImageIdentifier object itself.
     */
    public CommunityGalleryImageIdentifier withOffer(String offer) {
        this.offer = offer;
        return this;
    }

    /**
     * Get the sku property: The name of the gallery image definition SKU.
     * 
     * @return the sku value.
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The name of the gallery image definition SKU.
     * 
     * @param sku the sku value to set.
     * @return the CommunityGalleryImageIdentifier object itself.
     */
    public CommunityGalleryImageIdentifier withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
