// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.VirtualMachineRunCommandsClient;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentBaseInner;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineRunCommandInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.RunCommandListResult;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandUpdate;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandsListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in VirtualMachineRunCommandsClient.
 */
public final class VirtualMachineRunCommandsClientImpl implements VirtualMachineRunCommandsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final VirtualMachineRunCommandsService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of VirtualMachineRunCommandsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    VirtualMachineRunCommandsClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(VirtualMachineRunCommandsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientVirtualMachineRunCommands to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    public interface VirtualMachineRunCommandsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RunCommandListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands/{commandId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RunCommandDocumentInner>> get(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @PathParam("commandId") String commandId,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vmName") String vmName,
            @PathParam("runCommandName") String runCommandName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") VirtualMachineRunCommandInner runCommand,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vmName") String vmName,
            @PathParam("runCommandName") String runCommandName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") VirtualMachineRunCommandUpdate runCommand,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vmName") String vmName,
            @PathParam("runCommandName") String runCommandName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachine(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vmName") String vmName,
            @PathParam("runCommandName") String runCommandName, @QueryParam("$expand") String expand,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineRunCommandsListResult>> listByVirtualMachine(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vmName") String vmName,
            @QueryParam("$expand") String expand, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RunCommandListResult>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineRunCommandsListResult>> listByVirtualMachineNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), location, apiVersion,
                this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<RunCommandDocumentBaseInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), location, apiVersion, this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RunCommandDocumentBaseInner> listAsync(String location) {
        return new PagedFlux<>(() -> listSinglePageAsync(location), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RunCommandDocumentBaseInner> listAsync(String location, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(location, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RunCommandDocumentBaseInner> list(String location) {
        return new PagedIterable<>(listAsync(location));
    }

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RunCommandDocumentBaseInner> list(String location, Context context) {
        return new PagedIterable<>(listAsync(location, context));
    }

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RunCommandDocumentInner>> getWithResponseAsync(String location, String commandId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (commandId == null) {
            return Mono.error(new IllegalArgumentException("Parameter commandId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), location, commandId, apiVersion,
                this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RunCommandDocumentInner>> getWithResponseAsync(String location, String commandId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (commandId == null) {
            return Mono.error(new IllegalArgumentException("Parameter commandId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), location, commandId, apiVersion, this.client.getSubscriptionId(),
            accept, context);
    }

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RunCommandDocumentInner> getAsync(String location, String commandId) {
        return getWithResponseAsync(location, commandId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RunCommandDocumentInner> getWithResponse(String location, String commandId, Context context) {
        return getWithResponseAsync(location, commandId, context).block();
    }

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The location upon which run commands is queried.
     * @param commandId The command id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RunCommandDocumentInner get(String location, String commandId) {
        return getWithResponse(location, commandId, Context.NONE).getValue();
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmName,
                runCommandName, apiVersion, this.client.getSubscriptionId(), runCommand, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, apiVersion,
            this.client.getSubscriptionId(), runCommand, accept, context);
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName,
            VirtualMachineRunCommandInner runCommand) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            this.client.getContext());
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName,
            VirtualMachineRunCommandInner runCommand, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand, context);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            context);
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).getSyncPoller();
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand,
        Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context)
            .getSyncPoller();
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandInner runCommand) {
        return createOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).block();
    }

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be created or updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandInner runCommand, Context context) {
        return createOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).block();
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName,
                apiVersion, this.client.getSubscriptionId(), runCommand, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, apiVersion,
            this.client.getSubscriptionId(), runCommand, accept, context);
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            this.client.getContext());
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand, context);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            context);
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).getSyncPoller();
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand,
        Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).getSyncPoller();
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        return beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand) {
        return updateAsync(resourceGroupName, vmName, runCommandName, runCommand).block();
    }

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be updated.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand, Context context) {
        return updateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).block();
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName,
                apiVersion, this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, apiVersion,
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName,
        String runCommandName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, vmName, runCommandName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName,
        String runCommandName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, vmName, runCommandName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName,
        String runCommandName) {
        return this.beginDeleteAsync(resourceGroupName, vmName, runCommandName).getSyncPoller();
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName,
        String runCommandName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmName, runCommandName, context).getSyncPoller();
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        return beginDeleteAsync(resourceGroupName, vmName, runCommandName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName, Context context) {
        return beginDeleteAsync(resourceGroupName, vmName, runCommandName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName, String runCommandName) {
        deleteAsync(resourceGroupName, vmName, runCommandName).block();
    }

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine where the run command should be deleted.
     * @param runCommandName The name of the virtual machine run command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName, String runCommandName, Context context) {
        deleteAsync(resourceGroupName, vmName, runCommandName, context).block();
    }

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachineWithResponseAsync(String resourceGroupName,
        String vmName, String runCommandName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.getByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName,
                runCommandName, expand, apiVersion, this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachineWithResponseAsync(String resourceGroupName,
        String vmName, String runCommandName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.getByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, expand,
            apiVersion, this.client.getSubscriptionId(), accept, context);
    }

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName,
        String runCommandName) {
        final String expand = null;
        return getByVirtualMachineWithResponseAsync(resourceGroupName, vmName, runCommandName, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<VirtualMachineRunCommandInner> getByVirtualMachineWithResponse(String resourceGroupName,
        String vmName, String runCommandName, String expand, Context context) {
        return getByVirtualMachineWithResponseAsync(resourceGroupName, vmName, runCommandName, expand, context).block();
    }

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName,
        String runCommandName) {
        final String expand = null;
        return getByVirtualMachineWithResponse(resourceGroupName, vmName, runCommandName, expand, Context.NONE)
            .getValue();
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>>
        listByVirtualMachineSinglePageAsync(String resourceGroupName, String vmName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(context -> service.listByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName,
                expand, apiVersion, this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<VirtualMachineRunCommandInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>>
        listByVirtualMachineSinglePageAsync(String resourceGroupName, String vmName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2024-03-01";
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service
            .listByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName, expand, apiVersion,
                this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName,
        String expand) {
        return new PagedFlux<>(() -> listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand),
            nextLink -> listByVirtualMachineNextSinglePageAsync(nextLink));
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName) {
        final String expand = null;
        return new PagedFlux<>(() -> listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand),
            nextLink -> listByVirtualMachineNextSinglePageAsync(nextLink));
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName,
        String expand, Context context) {
        return new PagedFlux<>(() -> listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand, context),
            nextLink -> listByVirtualMachineNextSinglePageAsync(nextLink, context));
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName) {
        final String expand = null;
        return new PagedIterable<>(listByVirtualMachineAsync(resourceGroupName, vmName, expand));
    }

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param vmName The name of the virtual machine containing the run command.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName,
        String expand, Context context) {
        return new PagedIterable<>(listByVirtualMachineAsync(resourceGroupName, vmName, expand, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RunCommandDocumentBaseInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>>
        listByVirtualMachineNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json, text/json";
        return FluxUtil
            .withContext(
                context -> service.listByVirtualMachineNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<VirtualMachineRunCommandInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listByVirtualMachineNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return service.listByVirtualMachineNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
