// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Additional settings for the VM app that contains the target package and config file name when it is deployed to
 * target VM or VM scale set.
 */
@Fluent
public final class UserArtifactSettings {
    /*
     * Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not
     * specified, the package file will be named the same as the Gallery Application name.
     */
    @JsonProperty(value = "packageFileName")
    private String packageFileName;

    /*
     * Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not
     * specified, the config file will be named the Gallery Application name appended with "_config".
     */
    @JsonProperty(value = "configFileName")
    private String configFileName;

    /**
     * Creates an instance of UserArtifactSettings class.
     */
    public UserArtifactSettings() {
    }

    /**
     * Get the packageFileName property: Optional. The name to assign the downloaded package file on the VM. This is
     * limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application
     * name.
     * 
     * @return the packageFileName value.
     */
    public String packageFileName() {
        return this.packageFileName;
    }

    /**
     * Set the packageFileName property: Optional. The name to assign the downloaded package file on the VM. This is
     * limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application
     * name.
     * 
     * @param packageFileName the packageFileName value to set.
     * @return the UserArtifactSettings object itself.
     */
    public UserArtifactSettings withPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
        return this;
    }

    /**
     * Get the configFileName property: Optional. The name to assign the downloaded config file on the VM. This is
     * limited to 4096 characters. If not specified, the config file will be named the Gallery Application name
     * appended with "_config".
     * 
     * @return the configFileName value.
     */
    public String configFileName() {
        return this.configFileName;
    }

    /**
     * Set the configFileName property: Optional. The name to assign the downloaded config file on the VM. This is
     * limited to 4096 characters. If not specified, the config file will be named the Gallery Application name
     * appended with "_config".
     * 
     * @param configFileName the configFileName value to set.
     * @return the UserArtifactSettings object itself.
     */
    public UserArtifactSettings withConfigFileName(String configFileName) {
        this.configFileName = configFileName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
