// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A UEFI key signature.
 */
@Fluent
public final class UefiKey {
    /*
     * The type of key signature.
     */
    @JsonProperty(value = "type")
    private UefiKeyType type;

    /*
     * The value of the key signature.
     */
    @JsonProperty(value = "value")
    private List<String> value;

    /**
     * Creates an instance of UefiKey class.
     */
    public UefiKey() {
    }

    /**
     * Get the type property: The type of key signature.
     * 
     * @return the type value.
     */
    public UefiKeyType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of key signature.
     * 
     * @param type the type value to set.
     * @return the UefiKey object itself.
     */
    public UefiKey withType(UefiKeyType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: The value of the key signature.
     * 
     * @return the value value.
     */
    public List<String> value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the key signature.
     * 
     * @param value the value value to set.
     * @return the UefiKey object itself.
     */
    public UefiKey withValue(List<String> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
