// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The TerminateNotificationProfile model.
 */
@Fluent
public final class TerminateNotificationProfile {
    /*
     * Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate
     * Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601
     * format, the default value is 5 minutes (PT5M)
     */
    @JsonProperty(value = "notBeforeTimeout")
    private String notBeforeTimeout;

    /*
     * Specifies whether the Terminate Scheduled event is enabled or disabled.
     */
    @JsonProperty(value = "enable")
    private Boolean enable;

    /**
     * Creates an instance of TerminateNotificationProfile class.
     */
    public TerminateNotificationProfile() {
    }

    /**
     * Get the notBeforeTimeout property: Configurable length of time a Virtual Machine being deleted will have to
     * potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The
     * configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M).
     * 
     * @return the notBeforeTimeout value.
     */
    public String notBeforeTimeout() {
        return this.notBeforeTimeout;
    }

    /**
     * Set the notBeforeTimeout property: Configurable length of time a Virtual Machine being deleted will have to
     * potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The
     * configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M).
     * 
     * @param notBeforeTimeout the notBeforeTimeout value to set.
     * @return the TerminateNotificationProfile object itself.
     */
    public TerminateNotificationProfile withNotBeforeTimeout(String notBeforeTimeout) {
        this.notBeforeTimeout = notBeforeTimeout;
        return this;
    }

    /**
     * Get the enable property: Specifies whether the Terminate Scheduled event is enabled or disabled.
     * 
     * @return the enable value.
     */
    public Boolean enable() {
        return this.enable;
    }

    /**
     * Set the enable property: Specifies whether the Terminate Scheduled event is enabled or disabled.
     * 
     * @param enable the enable value to set.
     * @return the TerminateNotificationProfile object itself.
     */
    public TerminateNotificationProfile withEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
