// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * This is the storage profile of a Gallery Image Version.
 */
@Fluent
public final class SharedGalleryImageVersionStorageProfile {
    /*
     * This is the OS disk image.
     */
    @JsonProperty(value = "osDiskImage")
    private SharedGalleryOSDiskImage osDiskImage;

    /*
     * A list of data disk images.
     */
    @JsonProperty(value = "dataDiskImages")
    private List<SharedGalleryDataDiskImage> dataDiskImages;

    /**
     * Creates an instance of SharedGalleryImageVersionStorageProfile class.
     */
    public SharedGalleryImageVersionStorageProfile() {
    }

    /**
     * Get the osDiskImage property: This is the OS disk image.
     * 
     * @return the osDiskImage value.
     */
    public SharedGalleryOSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    /**
     * Set the osDiskImage property: This is the OS disk image.
     * 
     * @param osDiskImage the osDiskImage value to set.
     * @return the SharedGalleryImageVersionStorageProfile object itself.
     */
    public SharedGalleryImageVersionStorageProfile withOsDiskImage(SharedGalleryOSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    /**
     * Get the dataDiskImages property: A list of data disk images.
     * 
     * @return the dataDiskImages value.
     */
    public List<SharedGalleryDataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    /**
     * Set the dataDiskImages property: A list of data disk images.
     * 
     * @param dataDiskImages the dataDiskImages value to set.
     * @return the SharedGalleryImageVersionStorageProfile object itself.
     */
    public SharedGalleryImageVersionStorageProfile withDataDiskImages(List<SharedGalleryDataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osDiskImage() != null) {
            osDiskImage().validate();
        }
        if (dataDiskImages() != null) {
            dataDiskImages().forEach(e -> e.validate());
        }
    }
}
