// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The type of key used to encrypt the data of the disk restore point.
 */
public final class RestorePointEncryptionType extends ExpandableStringEnum<RestorePointEncryptionType> {
    /**
     * Static value EncryptionAtRestWithPlatformKey for RestorePointEncryptionType.
     */
    public static final RestorePointEncryptionType ENCRYPTION_AT_REST_WITH_PLATFORM_KEY
        = fromString("EncryptionAtRestWithPlatformKey");

    /**
     * Static value EncryptionAtRestWithCustomerKey for RestorePointEncryptionType.
     */
    public static final RestorePointEncryptionType ENCRYPTION_AT_REST_WITH_CUSTOMER_KEY
        = fromString("EncryptionAtRestWithCustomerKey");

    /**
     * Static value EncryptionAtRestWithPlatformAndCustomerKeys for RestorePointEncryptionType.
     */
    public static final RestorePointEncryptionType ENCRYPTION_AT_REST_WITH_PLATFORM_AND_CUSTOMER_KEYS
        = fromString("EncryptionAtRestWithPlatformAndCustomerKeys");

    /**
     * Creates a new instance of RestorePointEncryptionType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RestorePointEncryptionType() {
    }

    /**
     * Creates or finds a RestorePointEncryptionType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RestorePointEncryptionType.
     */
    @JsonCreator
    public static RestorePointEncryptionType fromString(String name) {
        return fromString(name, RestorePointEncryptionType.class);
    }

    /**
     * Gets known RestorePointEncryptionType values.
     * 
     * @return known RestorePointEncryptionType values.
     */
    public static Collection<RestorePointEncryptionType> values() {
        return values(RestorePointEncryptionType.class);
    }
}
