// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Defines values for RestorePointCollectionExpandOptions.
 */
public final class RestorePointCollectionExpandOptions
    extends ExpandableStringEnum<RestorePointCollectionExpandOptions> {
    /**
     * Static value restorePoints for RestorePointCollectionExpandOptions.
     */
    public static final RestorePointCollectionExpandOptions RESTORE_POINTS = fromString("restorePoints");

    /**
     * Creates a new instance of RestorePointCollectionExpandOptions value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RestorePointCollectionExpandOptions() {
    }

    /**
     * Creates or finds a RestorePointCollectionExpandOptions from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RestorePointCollectionExpandOptions.
     */
    @JsonCreator
    public static RestorePointCollectionExpandOptions fromString(String name) {
        return fromString(name, RestorePointCollectionExpandOptions.class);
    }

    /**
     * Gets known RestorePointCollectionExpandOptions values.
     * 
     * @return known RestorePointCollectionExpandOptions values.
     */
    public static Collection<RestorePointCollectionExpandOptions> values() {
        return values(RestorePointCollectionExpandOptions.class);
    }
}
