// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * This property allows you to specify the permission of sharing gallery. Possible values are: **Private,** **Groups,**
 * **Community.**.
 */
public final class GallerySharingPermissionTypes extends ExpandableStringEnum<GallerySharingPermissionTypes> {
    /**
     * Static value Private for GallerySharingPermissionTypes.
     */
    public static final GallerySharingPermissionTypes PRIVATE = fromString("Private");

    /**
     * Static value Groups for GallerySharingPermissionTypes.
     */
    public static final GallerySharingPermissionTypes GROUPS = fromString("Groups");

    /**
     * Static value Community for GallerySharingPermissionTypes.
     */
    public static final GallerySharingPermissionTypes COMMUNITY = fromString("Community");

    /**
     * Creates a new instance of GallerySharingPermissionTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GallerySharingPermissionTypes() {
    }

    /**
     * Creates or finds a GallerySharingPermissionTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GallerySharingPermissionTypes.
     */
    @JsonCreator
    public static GallerySharingPermissionTypes fromString(String name) {
        return fromString(name, GallerySharingPermissionTypes.class);
    }

    /**
     * Gets known GallerySharingPermissionTypes values.
     * 
     * @return known GallerySharingPermissionTypes values.
     */
    public static Collection<GallerySharingPermissionTypes> values() {
        return values(GallerySharingPermissionTypes.class);
    }
}
