// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies the Managed Identity used by ADE to get access token for keyvault operations.
 */
@Fluent
public final class EncryptionIdentity {
    /*
     * Specifies ARM Resource ID of one of the user identities associated with the VM.
     */
    @JsonProperty(value = "userAssignedIdentityResourceId")
    private String userAssignedIdentityResourceId;

    /**
     * Creates an instance of EncryptionIdentity class.
     */
    public EncryptionIdentity() {
    }

    /**
     * Get the userAssignedIdentityResourceId property: Specifies ARM Resource ID of one of the user identities
     * associated with the VM.
     * 
     * @return the userAssignedIdentityResourceId value.
     */
    public String userAssignedIdentityResourceId() {
        return this.userAssignedIdentityResourceId;
    }

    /**
     * Set the userAssignedIdentityResourceId property: Specifies ARM Resource ID of one of the user identities
     * associated with the VM.
     * 
     * @param userAssignedIdentityResourceId the userAssignedIdentityResourceId value to set.
     * @return the EncryptionIdentity object itself.
     */
    public EncryptionIdentity withUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
        this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
