// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetUpdateProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * disk encryption set update resource.
 */
@Fluent
public final class DiskEncryptionSetUpdate {
    /*
     * disk encryption set resource update properties.
     */
    @JsonProperty(value = "properties")
    private DiskEncryptionSetUpdateProperties innerProperties;

    /*
     * Resource tags
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * The managed identity for the disk encryption set. It should be given permission on the key vault before it can
     * be used to encrypt disks.
     */
    @JsonProperty(value = "identity")
    private EncryptionSetIdentity identity;

    /**
     * Creates an instance of DiskEncryptionSetUpdate class.
     */
    public DiskEncryptionSetUpdate() {
    }

    /**
     * Get the innerProperties property: disk encryption set resource update properties.
     * 
     * @return the innerProperties value.
     */
    private DiskEncryptionSetUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the DiskEncryptionSetUpdate object itself.
     */
    public DiskEncryptionSetUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the identity property: The managed identity for the disk encryption set. It should be given permission on
     * the key vault before it can be used to encrypt disks.
     * 
     * @return the identity value.
     */
    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The managed identity for the disk encryption set. It should be given permission on
     * the key vault before it can be used to encrypt disks.
     * 
     * @param identity the identity value to set.
     * @return the DiskEncryptionSetUpdate object itself.
     */
    public DiskEncryptionSetUpdate withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the encryptionType property: The type of key used to encrypt the data of the disk.
     * 
     * @return the encryptionType value.
     */
    public DiskEncryptionSetType encryptionType() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionType();
    }

    /**
     * Set the encryptionType property: The type of key used to encrypt the data of the disk.
     * 
     * @param encryptionType the encryptionType value to set.
     * @return the DiskEncryptionSetUpdate object itself.
     */
    public DiskEncryptionSetUpdate withEncryptionType(DiskEncryptionSetType encryptionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withEncryptionType(encryptionType);
        return this;
    }

    /**
     * Get the activeKey property: Key Vault Key Url to be used for server side encryption of Managed Disks and
     * Snapshots.
     * 
     * @return the activeKey value.
     */
    public KeyForDiskEncryptionSet activeKey() {
        return this.innerProperties() == null ? null : this.innerProperties().activeKey();
    }

    /**
     * Set the activeKey property: Key Vault Key Url to be used for server side encryption of Managed Disks and
     * Snapshots.
     * 
     * @param activeKey the activeKey value to set.
     * @return the DiskEncryptionSetUpdate object itself.
     */
    public DiskEncryptionSetUpdate withActiveKey(KeyForDiskEncryptionSet activeKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withActiveKey(activeKey);
        return this;
    }

    /**
     * Get the rotationToLatestKeyVersionEnabled property: Set this flag to true to enable auto-updating of this disk
     * encryption set to the latest key version.
     * 
     * @return the rotationToLatestKeyVersionEnabled value.
     */
    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationToLatestKeyVersionEnabled();
    }

    /**
     * Set the rotationToLatestKeyVersionEnabled property: Set this flag to true to enable auto-updating of this disk
     * encryption set to the latest key version.
     * 
     * @param rotationToLatestKeyVersionEnabled the rotationToLatestKeyVersionEnabled value to set.
     * @return the DiskEncryptionSetUpdate object itself.
     */
    public DiskEncryptionSetUpdate withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withRotationToLatestKeyVersionEnabled(rotationToLatestKeyVersionEnabled);
        return this;
    }

    /**
     * Get the federatedClientId property: Multi-tenant application client id to access key vault in a different
     * tenant. Setting the value to 'None' will clear the property.
     * 
     * @return the federatedClientId value.
     */
    public String federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    /**
     * Set the federatedClientId property: Multi-tenant application client id to access key vault in a different
     * tenant. Setting the value to 'None' will clear the property.
     * 
     * @param federatedClientId the federatedClientId value to set.
     * @return the DiskEncryptionSetUpdate object itself.
     */
    public DiskEncryptionSetUpdate withFederatedClientId(String federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }
}
