// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the data disk to be attached.
 */
@Fluent
public final class DataDisksToAttach {
    /*
     * ID of the managed data disk.
     */
    @JsonProperty(value = "diskId", required = true)
    private String diskId;

    /*
     * The logical unit number of the data disk. This value is used to identify data disks within the VM and therefore
     * must be unique for each data disk attached to a VM. If not specified, lun would be auto assigned.
     */
    @JsonProperty(value = "lun")
    private Integer lun;

    /**
     * Creates an instance of DataDisksToAttach class.
     */
    public DataDisksToAttach() {
    }

    /**
     * Get the diskId property: ID of the managed data disk.
     * 
     * @return the diskId value.
     */
    public String diskId() {
        return this.diskId;
    }

    /**
     * Set the diskId property: ID of the managed data disk.
     * 
     * @param diskId the diskId value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    /**
     * Get the lun property: The logical unit number of the data disk. This value is used to identify data disks within
     * the VM and therefore must be unique for each data disk attached to a VM. If not specified, lun would be auto
     * assigned.
     * 
     * @return the lun value.
     */
    public Integer lun() {
        return this.lun;
    }

    /**
     * Set the lun property: The logical unit number of the data disk. This value is used to identify data disks within
     * the VM and therefore must be unique for each data disk attached to a VM. If not specified, lun would be auto
     * assigned.
     * 
     * @param lun the lun value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withLun(Integer lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskId() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property diskId in model DataDisksToAttach"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToAttach.class);
}
