// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only
 * CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
 */
public final class ConsistencyModeTypes extends ExpandableStringEnum<ConsistencyModeTypes> {
    /**
     * Static value CrashConsistent for ConsistencyModeTypes.
     */
    public static final ConsistencyModeTypes CRASH_CONSISTENT = fromString("CrashConsistent");

    /**
     * Static value FileSystemConsistent for ConsistencyModeTypes.
     */
    public static final ConsistencyModeTypes FILE_SYSTEM_CONSISTENT = fromString("FileSystemConsistent");

    /**
     * Static value ApplicationConsistent for ConsistencyModeTypes.
     */
    public static final ConsistencyModeTypes APPLICATION_CONSISTENT = fromString("ApplicationConsistent");

    /**
     * Creates a new instance of ConsistencyModeTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConsistencyModeTypes() {
    }

    /**
     * Creates or finds a ConsistencyModeTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConsistencyModeTypes.
     */
    @JsonCreator
    public static ConsistencyModeTypes fromString(String name) {
        return fromString(name, ConsistencyModeTypes.class);
    }

    /**
     * Gets known ConsistencyModeTypes values.
     * 
     * @return known ConsistencyModeTypes values.
     */
    public static Collection<ConsistencyModeTypes> values() {
        return values(ConsistencyModeTypes.class);
    }
}
