// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role
 * instance.
 */
@Fluent
public final class CloudServiceVaultCertificate {
    /*
     * This is the URL of a certificate that has been uploaded to Key Vault as a secret.
     */
    @JsonProperty(value = "certificateUrl")
    private String certificateUrl;

    /**
     * Creates an instance of CloudServiceVaultCertificate class.
     */
    public CloudServiceVaultCertificate() {
    }

    /**
     * Get the certificateUrl property: This is the URL of a certificate that has been uploaded to Key Vault as a
     * secret.
     * 
     * @return the certificateUrl value.
     */
    public String certificateUrl() {
        return this.certificateUrl;
    }

    /**
     * Set the certificateUrl property: This is the URL of a certificate that has been uploaded to Key Vault as a
     * secret.
     * 
     * @param certificateUrl the certificateUrl value to set.
     * @return the CloudServiceVaultCertificate object itself.
     */
    public CloudServiceVaultCertificate withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
