// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The list capacity reservation operation response.
 */
@Fluent
public final class CapacityReservationListResult {
    /*
     * The list of capacity reservations
     */
    @JsonProperty(value = "value", required = true)
    private List<CapacityReservationInner> value;

    /*
     * The URI to fetch the next page of capacity reservations. Call ListNext() with this URI to fetch the next page of
     * capacity reservations.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of CapacityReservationListResult class.
     */
    public CapacityReservationListResult() {
    }

    /**
     * Get the value property: The list of capacity reservations.
     * 
     * @return the value value.
     */
    public List<CapacityReservationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of capacity reservations.
     * 
     * @param value the value value to set.
     * @return the CapacityReservationListResult object itself.
     */
    public CapacityReservationListResult withValue(List<CapacityReservationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of capacity reservations. Call ListNext() with this
     * URI to fetch the next page of capacity reservations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of capacity reservations. Call ListNext() with this
     * URI to fetch the next page of capacity reservations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CapacityReservationListResult object itself.
     */
    public CapacityReservationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property value in model CapacityReservationListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CapacityReservationListResult.class);
}
