// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine
 * scale set with OrchestrationMode as Flexible.&lt;br /&gt;&lt;br /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt;
 * **Manual** - You control the application of patches to a virtual machine. You do this by applying patches manually
 * inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates
 * must be false&lt;br /&gt;&lt;br /&gt; **AutomaticByOS** - The virtual machine will automatically be updated by the
 * OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. &lt;br /&gt;&lt;br /&gt;
 * **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties
 * provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true.
 */
public final class WindowsVMGuestPatchMode extends ExpandableStringEnum<WindowsVMGuestPatchMode> {
    /**
     * Static value Manual for WindowsVMGuestPatchMode.
     */
    public static final WindowsVMGuestPatchMode MANUAL = fromString("Manual");

    /**
     * Static value AutomaticByOS for WindowsVMGuestPatchMode.
     */
    public static final WindowsVMGuestPatchMode AUTOMATIC_BY_OS = fromString("AutomaticByOS");

    /**
     * Static value AutomaticByPlatform for WindowsVMGuestPatchMode.
     */
    public static final WindowsVMGuestPatchMode AUTOMATIC_BY_PLATFORM = fromString("AutomaticByPlatform");

    /**
     * Creates a new instance of WindowsVMGuestPatchMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WindowsVMGuestPatchMode() {
    }

    /**
     * Creates or finds a WindowsVMGuestPatchMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding WindowsVMGuestPatchMode.
     */
    @JsonCreator
    public static WindowsVMGuestPatchMode fromString(String name) {
        return fromString(name, WindowsVMGuestPatchMode.class);
    }

    /**
     * Gets known WindowsVMGuestPatchMode values.
     * 
     * @return known WindowsVMGuestPatchMode values.
     */
    public static Collection<WindowsVMGuestPatchMode> values() {
        return values(WindowsVMGuestPatchMode.class);
    }
}
