// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The level code.
 */
public enum StatusLevelTypes {
    /**
     * Enum value Info.
     */
    INFO("Info"),

    /**
     * Enum value Warning.
     */
    WARNING("Warning"),

    /**
     * Enum value Error.
     */
    ERROR("Error");

    /**
     * The actual serialized value for a StatusLevelTypes instance.
     */
    private final String value;

    StatusLevelTypes(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a StatusLevelTypes instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed StatusLevelTypes object, or null if unable to parse.
     */
    @JsonCreator
    public static StatusLevelTypes fromString(String value) {
        if (value == null) {
            return null;
        }
        StatusLevelTypes[] items = StatusLevelTypes.values();
        for (StatusLevelTypes item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
