// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of restrictions.
 */
public enum ResourceSkuRestrictionsType {
    /**
     * Enum value Location.
     */
    LOCATION("Location"),

    /**
     * Enum value Zone.
     */
    ZONE("Zone");

    /**
     * The actual serialized value for a ResourceSkuRestrictionsType instance.
     */
    private final String value;

    ResourceSkuRestrictionsType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResourceSkuRestrictionsType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResourceSkuRestrictionsType object, or null if unable to parse.
     */
    @JsonCreator
    public static ResourceSkuRestrictionsType fromString(String value) {
        if (value == null) {
            return null;
        }
        ResourceSkuRestrictionsType[] items = ResourceSkuRestrictionsType.values();
        for (ResourceSkuRestrictionsType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
