// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes an resiliency policy - resilientVMCreationPolicy and/or resilientVMDeletionPolicy.
 */
@Fluent
public final class ResiliencyPolicy {
    /*
     * The configuration parameters used while performing resilient VM creation.
     */
    @JsonProperty(value = "resilientVMCreationPolicy")
    private ResilientVMCreationPolicy resilientVMCreationPolicy;

    /*
     * The configuration parameters used while performing resilient VM deletion.
     */
    @JsonProperty(value = "resilientVMDeletionPolicy")
    private ResilientVMDeletionPolicy resilientVMDeletionPolicy;

    /**
     * Creates an instance of ResiliencyPolicy class.
     */
    public ResiliencyPolicy() {
    }

    /**
     * Get the resilientVMCreationPolicy property: The configuration parameters used while performing resilient VM
     * creation.
     * 
     * @return the resilientVMCreationPolicy value.
     */
    public ResilientVMCreationPolicy resilientVMCreationPolicy() {
        return this.resilientVMCreationPolicy;
    }

    /**
     * Set the resilientVMCreationPolicy property: The configuration parameters used while performing resilient VM
     * creation.
     * 
     * @param resilientVMCreationPolicy the resilientVMCreationPolicy value to set.
     * @return the ResiliencyPolicy object itself.
     */
    public ResiliencyPolicy withResilientVMCreationPolicy(ResilientVMCreationPolicy resilientVMCreationPolicy) {
        this.resilientVMCreationPolicy = resilientVMCreationPolicy;
        return this;
    }

    /**
     * Get the resilientVMDeletionPolicy property: The configuration parameters used while performing resilient VM
     * deletion.
     * 
     * @return the resilientVMDeletionPolicy value.
     */
    public ResilientVMDeletionPolicy resilientVMDeletionPolicy() {
        return this.resilientVMDeletionPolicy;
    }

    /**
     * Set the resilientVMDeletionPolicy property: The configuration parameters used while performing resilient VM
     * deletion.
     * 
     * @param resilientVMDeletionPolicy the resilientVMDeletionPolicy value to set.
     * @return the ResiliencyPolicy object itself.
     */
    public ResiliencyPolicy withResilientVMDeletionPolicy(ResilientVMDeletionPolicy resilientVMDeletionPolicy) {
        this.resilientVMDeletionPolicy = resilientVMDeletionPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resilientVMCreationPolicy() != null) {
            resilientVMCreationPolicy().validate();
        }
        if (resilientVMDeletionPolicy() != null) {
            resilientVMDeletionPolicy().validate();
        }
    }
}
