// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Describes the availability of a given patch.
 */
public final class PatchAssessmentState extends ExpandableStringEnum<PatchAssessmentState> {
    /**
     * Static value Unknown for PatchAssessmentState.
     */
    public static final PatchAssessmentState UNKNOWN = fromString("Unknown");

    /**
     * Static value Available for PatchAssessmentState.
     */
    public static final PatchAssessmentState AVAILABLE = fromString("Available");

    /**
     * Creates a new instance of PatchAssessmentState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PatchAssessmentState() {
    }

    /**
     * Creates or finds a PatchAssessmentState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PatchAssessmentState.
     */
    @JsonCreator
    public static PatchAssessmentState fromString(String name) {
        return fromString(name, PatchAssessmentState.class);
    }

    /**
     * Gets known PatchAssessmentState values.
     * 
     * @return known PatchAssessmentState values.
     */
    public static Collection<PatchAssessmentState> values() {
        return values(PatchAssessmentState.class);
    }
}
