// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The security profile of a gallery image version.
 */
@Fluent
public final class ImageVersionSecurityProfile {
    /*
     * Contains UEFI settings for the image version.
     */
    @JsonProperty(value = "uefiSettings")
    private GalleryImageVersionUefiSettings uefiSettings;

    /**
     * Creates an instance of ImageVersionSecurityProfile class.
     */
    public ImageVersionSecurityProfile() {
    }

    /**
     * Get the uefiSettings property: Contains UEFI settings for the image version.
     * 
     * @return the uefiSettings value.
     */
    public GalleryImageVersionUefiSettings uefiSettings() {
        return this.uefiSettings;
    }

    /**
     * Set the uefiSettings property: Contains UEFI settings for the image version.
     * 
     * @param uefiSettings the uefiSettings value to set.
     * @return the ImageVersionSecurityProfile object itself.
     */
    public ImageVersionSecurityProfile withUefiSettings(GalleryImageVersionUefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (uefiSettings() != null) {
            uefiSettings().validate();
        }
    }
}
