// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Additional authentication requirements when exporting or uploading to a disk or snapshot.
 */
public final class DataAccessAuthMode extends ExpandableStringEnum<DataAccessAuthMode> {
    /**
     * Static value AzureActiveDirectory for DataAccessAuthMode.
     */
    public static final DataAccessAuthMode AZURE_ACTIVE_DIRECTORY = fromString("AzureActiveDirectory");

    /**
     * Static value None for DataAccessAuthMode.
     */
    public static final DataAccessAuthMode NONE = fromString("None");

    /**
     * Creates a new instance of DataAccessAuthMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DataAccessAuthMode() {
    }

    /**
     * Creates or finds a DataAccessAuthMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DataAccessAuthMode.
     */
    @JsonCreator
    public static DataAccessAuthMode fromString(String name) {
        return fromString(name, DataAccessAuthMode.class);
    }

    /**
     * Gets known DataAccessAuthMode values.
     * 
     * @return known DataAccessAuthMode values.
     */
    public static Collection<DataAccessAuthMode> values() {
        return values(DataAccessAuthMode.class);
    }
}
