// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupPropertiesIntent;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.SubResourceWithColocationStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Describes the properties of a Proximity Placement Group.
 */
@Fluent
public final class ProximityPlacementGroupProperties {
    /*
     * Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources
     * within an Azure region or Availability Zone. **Ultra** : For future use.
     */
    @JsonProperty(value = "proximityPlacementGroupType")
    private ProximityPlacementGroupType proximityPlacementGroupType;

    /*
     * A list of references to all virtual machines in the proximity placement group.
     */
    @JsonProperty(value = "virtualMachines", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceWithColocationStatus> virtualMachines;

    /*
     * A list of references to all virtual machine scale sets in the proximity placement group.
     */
    @JsonProperty(value = "virtualMachineScaleSets", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceWithColocationStatus> virtualMachineScaleSets;

    /*
     * A list of references to all availability sets in the proximity placement group.
     */
    @JsonProperty(value = "availabilitySets", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceWithColocationStatus> availabilitySets;

    /*
     * Describes colocation status of the Proximity Placement Group.
     */
    @JsonProperty(value = "colocationStatus")
    private InstanceViewStatus colocationStatus;

    /*
     * Specifies the user intent of the proximity placement group.
     */
    @JsonProperty(value = "intent")
    private ProximityPlacementGroupPropertiesIntent intent;

    /**
     * Creates an instance of ProximityPlacementGroupProperties class.
     */
    public ProximityPlacementGroupProperties() {
    }

    /**
     * Get the proximityPlacementGroupType property: Specifies the type of the proximity placement group. Possible
     * values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For
     * future use.
     * 
     * @return the proximityPlacementGroupType value.
     */
    public ProximityPlacementGroupType proximityPlacementGroupType() {
        return this.proximityPlacementGroupType;
    }

    /**
     * Set the proximityPlacementGroupType property: Specifies the type of the proximity placement group. Possible
     * values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For
     * future use.
     * 
     * @param proximityPlacementGroupType the proximityPlacementGroupType value to set.
     * @return the ProximityPlacementGroupProperties object itself.
     */
    public ProximityPlacementGroupProperties
        withProximityPlacementGroupType(ProximityPlacementGroupType proximityPlacementGroupType) {
        this.proximityPlacementGroupType = proximityPlacementGroupType;
        return this;
    }

    /**
     * Get the virtualMachines property: A list of references to all virtual machines in the proximity placement group.
     * 
     * @return the virtualMachines value.
     */
    public List<SubResourceWithColocationStatus> virtualMachines() {
        return this.virtualMachines;
    }

    /**
     * Get the virtualMachineScaleSets property: A list of references to all virtual machine scale sets in the
     * proximity placement group.
     * 
     * @return the virtualMachineScaleSets value.
     */
    public List<SubResourceWithColocationStatus> virtualMachineScaleSets() {
        return this.virtualMachineScaleSets;
    }

    /**
     * Get the availabilitySets property: A list of references to all availability sets in the proximity placement
     * group.
     * 
     * @return the availabilitySets value.
     */
    public List<SubResourceWithColocationStatus> availabilitySets() {
        return this.availabilitySets;
    }

    /**
     * Get the colocationStatus property: Describes colocation status of the Proximity Placement Group.
     * 
     * @return the colocationStatus value.
     */
    public InstanceViewStatus colocationStatus() {
        return this.colocationStatus;
    }

    /**
     * Set the colocationStatus property: Describes colocation status of the Proximity Placement Group.
     * 
     * @param colocationStatus the colocationStatus value to set.
     * @return the ProximityPlacementGroupProperties object itself.
     */
    public ProximityPlacementGroupProperties withColocationStatus(InstanceViewStatus colocationStatus) {
        this.colocationStatus = colocationStatus;
        return this;
    }

    /**
     * Get the intent property: Specifies the user intent of the proximity placement group.
     * 
     * @return the intent value.
     */
    public ProximityPlacementGroupPropertiesIntent intent() {
        return this.intent;
    }

    /**
     * Set the intent property: Specifies the user intent of the proximity placement group.
     * 
     * @param intent the intent value to set.
     * @return the ProximityPlacementGroupProperties object itself.
     */
    public ProximityPlacementGroupProperties withIntent(ProximityPlacementGroupPropertiesIntent intent) {
        this.intent = intent;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualMachines() != null) {
            virtualMachines().forEach(e -> e.validate());
        }
        if (virtualMachineScaleSets() != null) {
            virtualMachineScaleSets().forEach(e -> e.validate());
        }
        if (availabilitySets() != null) {
            availabilitySets().forEach(e -> e.validate());
        }
        if (colocationStatus() != null) {
            colocationStatus().validate();
        }
        if (intent() != null) {
            intent().validate();
        }
    }
}
