// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Base information about the shared gallery resource in pir.
 */
@Fluent
public class PirSharedGalleryResource extends PirResource {
    /*
     * The identifier information of shared gallery.
     */
    @JsonProperty(value = "identifier")
    private SharedGalleryIdentifier innerIdentifier;

    /**
     * Creates an instance of PirSharedGalleryResource class.
     */
    public PirSharedGalleryResource() {
    }

    /**
     * Get the innerIdentifier property: The identifier information of shared gallery.
     * 
     * @return the innerIdentifier value.
     */
    private SharedGalleryIdentifier innerIdentifier() {
        return this.innerIdentifier;
    }

    /**
     * Get the uniqueId property: The unique id of this shared gallery.
     * 
     * @return the uniqueId value.
     */
    public String uniqueId() {
        return this.innerIdentifier() == null ? null : this.innerIdentifier().uniqueId();
    }

    /**
     * Set the uniqueId property: The unique id of this shared gallery.
     * 
     * @param uniqueId the uniqueId value to set.
     * @return the PirSharedGalleryResource object itself.
     */
    public PirSharedGalleryResource withUniqueId(String uniqueId) {
        if (this.innerIdentifier() == null) {
            this.innerIdentifier = new SharedGalleryIdentifier();
        }
        this.innerIdentifier().withUniqueId(uniqueId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerIdentifier() != null) {
            innerIdentifier().validate();
        }
    }
}
