// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * OS version properties.
 */
@Immutable
public final class OSVersionProperties {
    /*
     * The family of this OS version.
     */
    @JsonProperty(value = "family", access = JsonProperty.Access.WRITE_ONLY)
    private String family;

    /*
     * The family label of this OS version.
     */
    @JsonProperty(value = "familyLabel", access = JsonProperty.Access.WRITE_ONLY)
    private String familyLabel;

    /*
     * The OS version.
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private String version;

    /*
     * The OS version label.
     */
    @JsonProperty(value = "label", access = JsonProperty.Access.WRITE_ONLY)
    private String label;

    /*
     * Specifies whether this is the default OS version for its family.
     */
    @JsonProperty(value = "isDefault", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isDefault;

    /*
     * Specifies whether this OS version is active.
     */
    @JsonProperty(value = "isActive", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isActive;

    /**
     * Creates an instance of OSVersionProperties class.
     */
    public OSVersionProperties() {
    }

    /**
     * Get the family property: The family of this OS version.
     * 
     * @return the family value.
     */
    public String family() {
        return this.family;
    }

    /**
     * Get the familyLabel property: The family label of this OS version.
     * 
     * @return the familyLabel value.
     */
    public String familyLabel() {
        return this.familyLabel;
    }

    /**
     * Get the version property: The OS version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the label property: The OS version label.
     * 
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Get the isDefault property: Specifies whether this is the default OS version for its family.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Get the isActive property: Specifies whether this OS version is active.
     * 
     * @return the isActive value.
     */
    public Boolean isActive() {
        return this.isActive;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
