// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Specifies the ephemeral disk placement for operating system disk. This property can be used by user in the request to
 * choose the location i.e, cache disk or resource disk space for Ephemeral OS disk provisioning. For more information
 * on Ephemeral OS disk size requirements, please refer Ephemeral OS disk size requirements for Windows VM at
 * https://docs.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VM at
 * https://docs.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
 */
public final class DiffDiskPlacement extends ExpandableStringEnum<DiffDiskPlacement> {
    /**
     * Static value CacheDisk for DiffDiskPlacement.
     */
    public static final DiffDiskPlacement CACHE_DISK = fromString("CacheDisk");

    /**
     * Static value ResourceDisk for DiffDiskPlacement.
     */
    public static final DiffDiskPlacement RESOURCE_DISK = fromString("ResourceDisk");

    /**
     * Creates a new instance of DiffDiskPlacement value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DiffDiskPlacement() {
    }

    /**
     * Creates or finds a DiffDiskPlacement from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DiffDiskPlacement.
     */
    @JsonCreator
    public static DiffDiskPlacement fromString(String name) {
        return fromString(name, DiffDiskPlacement.class);
    }

    /**
     * Gets known DiffDiskPlacement values.
     * 
     * @return known DiffDiskPlacement values.
     */
    public static Collection<DiffDiskPlacement> values() {
        return values(DiffDiskPlacement.class);
    }
}
