// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.models.CapacityReservationGroupInstanceView;
import com.azure.resourcemanager.compute.models.ResourceSharingProfile;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * capacity reservation group Properties.
 */
@Fluent
public final class CapacityReservationGroupProperties {
    /*
     * A list of all capacity reservation resource ids that belong to capacity reservation group.
     */
    @JsonProperty(value = "capacityReservations", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> capacityReservations;

    /*
     * A list of references to all virtual machines associated to the capacity reservation group.
     */
    @JsonProperty(value = "virtualMachinesAssociated", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> virtualMachinesAssociated;

    /*
     * The capacity reservation group instance view which has the list of instance views for all the capacity
     * reservations that belong to the capacity reservation group.
     */
    @JsonProperty(value = "instanceView", access = JsonProperty.Access.WRITE_ONLY)
    private CapacityReservationGroupInstanceView instanceView;

    /*
     * Specifies the settings to enable sharing across subscriptions for the capacity reservation group resource. Pls.
     * keep in mind the capacity reservation group resource generally can be shared across subscriptions belonging to a
     * single azure AAD tenant or cross AAD tenant if there is a trust relationship established between the AAD
     * tenants. **Note:** Minimum api-version: 2023-09-01. Please refer to https://aka.ms/computereservationsharing for
     * more details.
     */
    @JsonProperty(value = "sharingProfile")
    private ResourceSharingProfile sharingProfile;

    /**
     * Creates an instance of CapacityReservationGroupProperties class.
     */
    public CapacityReservationGroupProperties() {
    }

    /**
     * Get the capacityReservations property: A list of all capacity reservation resource ids that belong to capacity
     * reservation group.
     * 
     * @return the capacityReservations value.
     */
    public List<SubResourceReadOnly> capacityReservations() {
        return this.capacityReservations;
    }

    /**
     * Get the virtualMachinesAssociated property: A list of references to all virtual machines associated to the
     * capacity reservation group.
     * 
     * @return the virtualMachinesAssociated value.
     */
    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.virtualMachinesAssociated;
    }

    /**
     * Get the instanceView property: The capacity reservation group instance view which has the list of instance views
     * for all the capacity reservations that belong to the capacity reservation group.
     * 
     * @return the instanceView value.
     */
    public CapacityReservationGroupInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the sharingProfile property: Specifies the settings to enable sharing across subscriptions for the capacity
     * reservation group resource. Pls. keep in mind the capacity reservation group resource generally can be shared
     * across subscriptions belonging to a single azure AAD tenant or cross AAD tenant if there is a trust relationship
     * established between the AAD tenants. **Note:** Minimum api-version: 2023-09-01. Please refer to
     * https://aka.ms/computereservationsharing for more details.
     * 
     * @return the sharingProfile value.
     */
    public ResourceSharingProfile sharingProfile() {
        return this.sharingProfile;
    }

    /**
     * Set the sharingProfile property: Specifies the settings to enable sharing across subscriptions for the capacity
     * reservation group resource. Pls. keep in mind the capacity reservation group resource generally can be shared
     * across subscriptions belonging to a single azure AAD tenant or cross AAD tenant if there is a trust relationship
     * established between the AAD tenants. **Note:** Minimum api-version: 2023-09-01. Please refer to
     * https://aka.ms/computereservationsharing for more details.
     * 
     * @param sharingProfile the sharingProfile value to set.
     * @return the CapacityReservationGroupProperties object itself.
     */
    public CapacityReservationGroupProperties withSharingProfile(ResourceSharingProfile sharingProfile) {
        this.sharingProfile = sharingProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capacityReservations() != null) {
            capacityReservations().forEach(e -> e.validate());
        }
        if (virtualMachinesAssociated() != null) {
            virtualMachinesAssociated().forEach(e -> e.validate());
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
        if (sharingProfile() != null) {
            sharingProfile().validate();
        }
    }
}
