/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.models.AvailabilitySet;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.DiffDiskPlacement;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.KnownLinuxVirtualMachineImage;
import com.azure.resourcemanager.compute.models.KnownWindowsVirtualMachineImage;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.PowerState;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroup;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.ResourceIdentityType;
import com.azure.resourcemanager.compute.models.RunCommandInput;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.RunCommandResult;
import com.azure.resourcemanager.compute.models.SecurityTypes;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineDataDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineDiskOptions;
import com.azure.resourcemanager.compute.models.VirtualMachineEncryption;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineExtension;
import com.azure.resourcemanager.compute.models.VirtualMachineInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSet;
import com.azure.resourcemanager.compute.models.VirtualMachineSize;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineUnmanagedDataDisk;
import com.azure.resourcemanager.compute.models.WinRMListener;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface VirtualMachine
extends GroupableResource<ComputeManager, VirtualMachineInner>,
Refreshable<VirtualMachine>,
Updatable<Update>,
HasNetworkInterfaces {
    public void deallocate();

    public Mono<Void> deallocateAsync();

    public void deallocate(boolean var1);

    public Mono<Void> deallocateAsync(boolean var1);

    public void generalize();

    public Mono<Void> generalizeAsync();

    public void powerOff();

    public Mono<Void> powerOffAsync();

    public void powerOff(boolean var1);

    public Mono<Void> powerOffAsync(boolean var1);

    public void restart();

    public Mono<Void> restartAsync();

    public void start();

    public Mono<Void> startAsync();

    public void redeploy();

    public Mono<Void> redeployAsync();

    public void simulateEviction();

    public Mono<Void> simulateEvictionAsync();

    public VirtualMachineEncryption diskEncryption();

    public void convertToManaged();

    public Mono<Void> convertToManagedAsync();

    public PagedIterable<VirtualMachineSize> availableSizes();

    public String capture(String var1, String var2, boolean var3);

    public Mono<String> captureAsync(String var1, String var2, boolean var3);

    public VirtualMachineInstanceView refreshInstanceView();

    public Mono<VirtualMachineInstanceView> refreshInstanceViewAsync();

    public RunCommandResult runPowerShellScript(List<String> var1, List<RunCommandInputParameter> var2);

    public Mono<RunCommandResult> runPowerShellScriptAsync(List<String> var1, List<RunCommandInputParameter> var2);

    public RunCommandResult runShellScript(List<String> var1, List<RunCommandInputParameter> var2);

    public Mono<RunCommandResult> runShellScriptAsync(List<String> var1, List<RunCommandInputParameter> var2);

    public RunCommandResult runCommand(RunCommandInput var1);

    public Mono<RunCommandResult> runCommandAsync(RunCommandInput var1);

    public boolean isManagedDiskEnabled();

    public String computerName();

    public VirtualMachineSizeTypes size();

    public OperatingSystemTypes osType();

    public String osUnmanagedDiskVhdUri();

    public CachingTypes osDiskCachingType();

    public int osDiskSize();

    public StorageAccountTypes osDiskStorageAccountType();

    public String osDiskId();

    public DeleteOptions osDiskDeleteOptions();

    public String osDiskDiskEncryptionSetId();

    public boolean isOSDiskEphemeral();

    public Map<Integer, VirtualMachineUnmanagedDataDisk> unmanagedDataDisks();

    public Map<Integer, VirtualMachineDataDisk> dataDisks();

    public PublicIpAddress getPrimaryPublicIPAddress();

    public String getPrimaryPublicIPAddressId();

    public String availabilitySetId();

    public String virtualMachineScaleSetId();

    public String provisioningState();

    public String licenseType();

    public ProximityPlacementGroup proximityPlacementGroup();

    public Mono<List<VirtualMachineExtension>> listExtensionsAsync();

    public Map<String, VirtualMachineExtension> listExtensions();

    public Plan plan();

    public StorageProfile storageProfile();

    public OSProfile osProfile();

    public DiagnosticsProfile diagnosticsProfile();

    public String vmId();

    public PowerState powerState();

    public VirtualMachineInstanceView instanceView();

    public Set<AvailabilityZoneId> availabilityZones();

    public boolean isBootDiagnosticsEnabled();

    public String bootDiagnosticsStorageUri();

    public boolean isManagedServiceIdentityEnabled();

    public String systemAssignedManagedServiceIdentityTenantId();

    public String systemAssignedManagedServiceIdentityPrincipalId();

    public ResourceIdentityType managedServiceIdentityType();

    public Set<String> userAssignedManagedServiceIdentityIds();

    public VirtualMachinePriorityTypes priority();

    public VirtualMachineEvictionPolicyTypes evictionPolicy();

    public BillingProfile billingProfile();

    public boolean isHibernationEnabled();

    public SecurityTypes securityType();

    public boolean isSecureBootEnabled();

    public boolean isVTpmEnabled();

    public OffsetDateTime timeCreated();

    public DeleteOptions primaryNetworkInterfaceDeleteOptions();

    public DeleteOptions networkInterfaceDeleteOptions(String var1);

    public String userData();

    public static interface Update
    extends Appliable<VirtualMachine>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithProximityPlacementGroup,
    UpdateStages.WithUnmanagedDataDisk,
    UpdateStages.WithManagedDataDisk,
    UpdateStages.WithSecondaryNetworkInterface,
    UpdateStages.WithExtension,
    UpdateStages.WithBootDiagnostics,
    UpdateStages.WithBillingProfile,
    UpdateStages.WithSystemAssignedManagedServiceIdentity,
    UpdateStages.WithUserAssignedManagedServiceIdentity,
    UpdateStages.WithLicenseType,
    UpdateStages.WithAdditionalCapacities,
    UpdateStages.WithOSDisk,
    UpdateStages.WithSecurityFeatures,
    UpdateStages.WithDeleteOptions,
    UpdateStages.WithUserData {
        public Update withOSDiskEncryptionSettings(DiskEncryptionSettings var1);

        public Update withDataDiskDefaultCachingType(CachingTypes var1);

        public Update withDataDiskDefaultStorageAccountType(StorageAccountTypes var1);

        public Update withDataDiskDefaultDeleteOptions(DeleteOptions var1);

        public Update withDataDiskDefaultDiskEncryptionSet(String var1);

        public Update withOSDiskCaching(CachingTypes var1);

        public Update withOSDiskSizeInGB(int var1);

        public Update withSize(String var1);

        public Update withSize(VirtualMachineSizeTypes var1);

        public Update withPriority(VirtualMachinePriorityTypes var1);
    }

    public static interface UpdateStages {

        public static interface WithUserData {
            public Update withUserData(String var1);
        }

        public static interface WithDeleteOptions {
            public Update withOsDiskDeleteOptions(DeleteOptions var1);

            public Update withPrimaryNetworkInterfaceDeleteOptions(DeleteOptions var1);

            public Update withNetworkInterfacesDeleteOptions(DeleteOptions var1, String ... var2);

            public Update withDataDisksDeleteOptions(DeleteOptions var1, Integer ... var2);
        }

        public static interface WithSecurityFeatures {
            public Update withSecureBoot();

            public Update withoutSecureBoot();

            public Update withVTpm();

            public Update withoutVTpm();
        }

        public static interface WithOSDisk {
            public Update withOSDisk(String var1);

            public Update withOSDisk(Disk var1);
        }

        public static interface WithAdditionalCapacities {
            public Update enableHibernation();

            public Update disableHibernation();
        }

        public static interface WithLicenseType {
            public Update withLicenseType(String var1);
        }

        public static interface WithUserAssignedManagedServiceIdentity {
            public Update withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            public Update withExistingUserAssignedManagedServiceIdentity(Identity var1);

            public Update withoutUserAssignedManagedServiceIdentity(String var1);
        }

        public static interface WithSystemAssignedIdentityBasedAccessOrUpdate
        extends Update {
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessTo(String var1, BuiltInRole var2);

            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessTo(String var1, String var2);

            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String var1);
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public WithSystemAssignedIdentityBasedAccessOrUpdate withSystemAssignedManagedServiceIdentity();

            public Update withoutSystemAssignedManagedServiceIdentity();
        }

        public static interface WithBootDiagnostics {
            public Update withBootDiagnosticsOnManagedStorageAccount();

            public Update withBootDiagnostics();

            public Update withBootDiagnostics(Creatable<StorageAccount> var1);

            public Update withBootDiagnostics(StorageAccount var1);

            public Update withBootDiagnostics(String var1);

            public Update withoutBootDiagnostics();
        }

        public static interface WithExtension {
            public VirtualMachineExtension.UpdateDefinitionStages.Blank<Update> defineNewExtension(String var1);

            public VirtualMachineExtension.Update updateExtension(String var1);

            public Update withoutExtension(String var1);
        }

        public static interface WithSecondaryNetworkInterface {
            public Update withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1);

            public Update withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1, DeleteOptions var2);

            public Update withExistingSecondaryNetworkInterface(NetworkInterface var1);

            public Update withoutSecondaryNetworkInterface(String var1);
        }

        public static interface WithManagedDataDisk {
            public Update withNewDataDisk(Creatable<Disk> var1);

            public Update withNewDataDisk(Creatable<Disk> var1, int var2, CachingTypes var3);

            public Update withNewDataDisk(int var1);

            public Update withNewDataDisk(int var1, int var2, CachingTypes var3);

            public Update withNewDataDisk(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public Update withNewDataDisk(int var1, int var2, VirtualMachineDiskOptions var3);

            public Update withExistingDataDisk(Disk var1);

            public Update withExistingDataDisk(Disk var1, int var2, CachingTypes var3);

            public Update withExistingDataDisk(Disk var1, int var2, int var3, CachingTypes var4);

            public Update withExistingDataDisk(Disk var1, int var2, int var3, VirtualMachineDiskOptions var4);

            public Update withoutDataDisk(int var1);
        }

        public static interface WithUnmanagedDataDisk {
            public Update withNewUnmanagedDataDisk(Integer var1);

            public Update withExistingUnmanagedDataDisk(String var1, String var2, String var3);

            public VirtualMachineUnmanagedDataDisk.UpdateDefinitionStages.Blank<Update> defineUnmanagedDataDisk(String var1);

            public VirtualMachineUnmanagedDataDisk.Update updateUnmanagedDataDisk(String var1);

            public Update withoutUnmanagedDataDisk(String var1);

            public Update withoutUnmanagedDataDisk(int var1);
        }

        public static interface WithBillingProfile {
            public Update withMaxPrice(Double var1);
        }

        public static interface WithProximityPlacementGroup {
            public Update withProximityPlacementGroup(String var1);

            public Update withoutProximityPlacementGroup();
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualMachine>,
        Resource.DefinitionWithTags<WithCreate>,
        WithOSDiskSettings,
        WithVMSize,
        WithStorageAccount,
        WithAvailabilitySet,
        WithSecondaryNetworkInterface,
        WithExtension,
        WithPlan,
        WithBootDiagnostics,
        WithPriority,
        WithBillingProfile,
        WithSystemAssignedManagedServiceIdentity,
        WithUserAssignedManagedServiceIdentity,
        WithLicenseType,
        WithAdditionalCapacities,
        WithNetworkInterfaceDeleteOptions,
        WithEphemeralOSDisk,
        WithScaleSet,
        WithSecurityTypes,
        WithUserData {
            public Accepted<VirtualMachine> beginCreate();
        }

        public static interface WithUserData {
            public WithCreate withUserData(String var1);
        }

        public static interface WithSecurityFeatures
        extends WithCreate {
            public WithSecurityFeatures withSecureBoot();

            public WithSecurityFeatures withVTpm();
        }

        public static interface WithSecurityTypes {
            public WithSecurityFeatures withTrustedLaunch();
        }

        public static interface WithAdditionalCapacities {
            public WithCreate enableHibernation();
        }

        public static interface WithNetworkInterfaceDeleteOptions {
            public WithCreate withPrimaryNetworkInterfaceDeleteOptions(DeleteOptions var1);
        }

        public static interface WithUnmanagedCreate
        extends WithUnmanagedDataDisk,
        WithCreate {
            public WithUnmanagedCreate withOSDiskVhdLocation(String var1, String var2);
        }

        public static interface WithManagedCreate
        extends WithManagedDataDisk,
        WithAvailabilityZone,
        WithCreate {
            public WithManagedCreate withOSDiskStorageAccountType(StorageAccountTypes var1);

            public WithManagedCreate withDataDiskDefaultCachingType(CachingTypes var1);

            public WithManagedCreate withDataDiskDefaultStorageAccountType(StorageAccountTypes var1);

            public WithManagedCreate withDataDiskDefaultDeleteOptions(DeleteOptions var1);

            public WithManagedCreate withDataDiskDefaultDiskEncryptionSet(String var1);
        }

        public static interface WithScaleSet {
            public WithManagedCreate withExistingVirtualMachineScaleSet(VirtualMachineScaleSet var1);
        }

        public static interface WithAvailabilityZone {
            public WithManagedCreate withAvailabilityZone(AvailabilityZoneId var1);
        }

        public static interface WithLicenseType {
            public WithCreate withLicenseType(String var1);
        }

        public static interface WithUserAssignedManagedServiceIdentity {
            public WithCreate withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            public WithCreate withExistingUserAssignedManagedServiceIdentity(Identity var1);
        }

        public static interface WithSystemAssignedIdentityBasedAccessOrCreate
        extends WithCreate {
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessTo(String var1, BuiltInRole var2);

            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessTo(String var1, String var2);

            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String var1);
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithBillingProfile {
            public WithCreate withMaxPrice(Double var1);
        }

        public static interface WithPriority {
            public WithCreate withPriority(VirtualMachinePriorityTypes var1);

            public WithCreate withLowPriority();

            public WithCreate withLowPriority(VirtualMachineEvictionPolicyTypes var1);

            public WithCreate withSpotPriority();

            public WithCreate withSpotPriority(VirtualMachineEvictionPolicyTypes var1);
        }

        public static interface WithBootDiagnostics {
            public WithCreate withBootDiagnosticsOnManagedStorageAccount();

            public WithCreate withBootDiagnostics();

            public WithCreate withBootDiagnostics(Creatable<StorageAccount> var1);

            public WithCreate withBootDiagnostics(StorageAccount var1);

            public WithCreate withBootDiagnostics(String var1);
        }

        public static interface WithPlan {
            public WithCreate withPlan(PurchasePlan var1);

            public WithCreate withPromotionalPlan(PurchasePlan var1, String var2);
        }

        public static interface WithExtension {
            public VirtualMachineExtension.DefinitionStages.Blank<WithCreate> defineNewExtension(String var1);
        }

        public static interface WithSecondaryNetworkInterface {
            public WithCreate withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1);

            public WithCreate withNewSecondaryNetworkInterface(Creatable<NetworkInterface> var1, DeleteOptions var2);

            public WithCreate withExistingSecondaryNetworkInterface(NetworkInterface var1);
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithAvailabilitySet {
            public WithCreate withNewAvailabilitySet(String var1);

            public WithCreate withNewAvailabilitySet(Creatable<AvailabilitySet> var1);

            public WithCreate withExistingAvailabilitySet(AvailabilitySet var1);
        }

        public static interface WithManagedDataDisk {
            public WithManagedCreate withNewDataDisk(Creatable<Disk> var1);

            public WithManagedCreate withNewDataDisk(Creatable<Disk> var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDisk(int var1);

            public WithManagedCreate withNewDataDisk(int var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDisk(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public WithManagedCreate withNewDataDisk(int var1, int var2, VirtualMachineDiskOptions var3);

            public WithManagedCreate withExistingDataDisk(Disk var1);

            public WithManagedCreate withExistingDataDisk(Disk var1, int var2, CachingTypes var3);

            public WithManagedCreate withExistingDataDisk(Disk var1, int var2, int var3, VirtualMachineDiskOptions var4);

            public WithManagedCreate withExistingDataDisk(Disk var1, int var2, int var3, CachingTypes var4);

            public WithManagedCreate withNewDataDiskFromImage(int var1);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, VirtualMachineDiskOptions var3);
        }

        public static interface WithUnmanagedDataDisk {
            public WithUnmanagedCreate withNewUnmanagedDataDisk(Integer var1);

            public WithUnmanagedCreate withExistingUnmanagedDataDisk(String var1, String var2, String var3);

            public VirtualMachineUnmanagedDataDisk.DefinitionStages.Blank<WithUnmanagedCreate> defineUnmanagedDataDisk(String var1);
        }

        public static interface WithVMSize {
            public WithCreate withSize(String var1);

            public WithCreate withSize(VirtualMachineSizeTypes var1);
        }

        public static interface WithEphemeralOSDisk {
            public WithManagedCreate withPlacement(DiffDiskPlacement var1);
        }

        public static interface WithOSDiskSettings {
            public WithCreate withOSDiskCaching(CachingTypes var1);

            public WithCreate withOSDiskEncryptionSettings(DiskEncryptionSettings var1);

            public WithCreate withOSDiskSizeInGB(int var1);

            public WithCreate withOSDiskName(String var1);

            public WithCreate withOSDiskDeleteOptions(DeleteOptions var1);

            public WithCreate withOSDiskDiskEncryptionSet(String var1);

            public WithEphemeralOSDisk withEphemeralOSDisk();
        }

        public static interface WithWindowsCreateUnmanaged
        extends WithFromImageCreateOptionsUnmanaged {
            public WithWindowsCreateUnmanaged withoutVMAgent();

            public WithWindowsCreateUnmanaged withoutAutoUpdate();

            public WithWindowsCreateUnmanaged withTimeZone(String var1);

            public WithWindowsCreateUnmanaged withWinRM(WinRMListener var1);
        }

        public static interface WithWindowsCreateManaged
        extends WithFromImageCreateOptionsManaged {
            public WithWindowsCreateManaged withoutVMAgent();

            public WithWindowsCreateManaged withoutAutoUpdate();

            public WithWindowsCreateManaged withTimeZone(String var1);

            public WithWindowsCreateManaged withWinRM(WinRMListener var1);
        }

        public static interface WithWindowsCreateManagedOrUnmanaged
        extends WithWindowsCreateManaged {
            public WithWindowsCreateUnmanaged withUnmanagedDisks();
        }

        public static interface WithLinuxCreateUnmanaged
        extends WithFromImageCreateOptionsUnmanaged {
            public WithLinuxCreateUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxCreateManaged
        extends WithFromImageCreateOptionsManaged {
            public WithLinuxCreateManaged withSsh(String var1);
        }

        public static interface WithLinuxCreateManagedOrUnmanaged
        extends WithFromImageCreateOptionsManagedOrUnmanaged {
            public WithLinuxCreateManagedOrUnmanaged withSsh(String var1);
        }

        public static interface WithFromImageCreateOptionsUnmanaged
        extends WithUnmanagedCreate {
            public WithFromImageCreateOptionsUnmanaged withCustomData(String var1);

            public WithFromImageCreateOptionsUnmanaged withComputerName(String var1);
        }

        public static interface WithFromImageCreateOptionsManaged
        extends WithManagedCreate {
            public WithFromImageCreateOptionsManaged withCustomData(String var1);

            public WithFromImageCreateOptionsManaged withComputerName(String var1);
        }

        public static interface WithFromImageCreateOptionsManagedOrUnmanaged
        extends WithFromImageCreateOptionsManaged {
            public WithFromImageCreateOptionsUnmanaged withUnmanagedDisks();
        }

        public static interface WithWindowsAdminPasswordUnmanaged {
            public WithWindowsCreateUnmanaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminPasswordManaged {
            public WithWindowsCreateManaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminPasswordManagedOrUnmanaged {
            public WithWindowsCreateManagedOrUnmanaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminUsernameUnmanaged {
            public WithWindowsAdminPasswordUnmanaged withAdminUsername(String var1);
        }

        public static interface WithWindowsAdminUsernameManaged {
            public WithWindowsAdminPasswordManaged withAdminUsername(String var1);
        }

        public static interface WithWindowsAdminUsernameManagedOrUnmanaged {
            public WithWindowsAdminPasswordManagedOrUnmanaged withAdminUsername(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyUnmanaged {
            public WithLinuxCreateUnmanaged withRootPassword(String var1);

            public WithLinuxCreateUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyManaged {
            public WithLinuxCreateManaged withRootPassword(String var1);

            public WithLinuxCreateManaged withSsh(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged {
            public WithLinuxCreateManagedOrUnmanaged withRootPassword(String var1);

            public WithLinuxCreateManagedOrUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxRootUsernameUnmanaged {
            public WithLinuxRootPasswordOrPublicKeyUnmanaged withRootUsername(String var1);
        }

        public static interface WithLinuxRootUsernameManaged {
            public WithLinuxRootPasswordOrPublicKeyManaged withRootUsername(String var1);
        }

        public static interface WithLinuxRootUsernameManagedOrUnmanaged {
            public WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged withRootUsername(String var1);
        }

        public static interface WithOS {
            public WithWindowsAdminUsernameManagedOrUnmanaged withPopularWindowsImage(KnownWindowsVirtualMachineImage var1);

            public WithWindowsAdminUsernameManagedOrUnmanaged withLatestWindowsImage(String var1, String var2, String var3);

            public WithWindowsAdminUsernameManagedOrUnmanaged withSpecificWindowsImageVersion(ImageReference var1);

            public WithWindowsAdminUsernameManaged withGeneralizedWindowsCustomImage(String var1);

            public WithWindowsCreateManaged withSpecializedWindowsCustomImage(String var1);

            public WithWindowsAdminUsernameManaged withGeneralizedWindowsGalleryImageVersion(String var1);

            public WithWindowsCreateManaged withSpecializedWindowsGalleryImageVersion(String var1);

            public WithWindowsAdminUsernameUnmanaged withStoredWindowsImage(String var1);

            public WithLinuxRootUsernameManagedOrUnmanaged withPopularLinuxImage(KnownLinuxVirtualMachineImage var1);

            public WithLinuxRootUsernameManagedOrUnmanaged withLatestLinuxImage(String var1, String var2, String var3);

            public WithLinuxRootUsernameManagedOrUnmanaged withSpecificLinuxImageVersion(ImageReference var1);

            public WithLinuxRootUsernameManaged withGeneralizedLinuxCustomImage(String var1);

            public WithLinuxCreateManaged withSpecializedLinuxCustomImage(String var1);

            public WithLinuxRootUsernameManaged withGeneralizedLinuxGalleryImageVersion(String var1);

            public WithLinuxCreateManaged withSpecializedLinuxGalleryImageVersion(String var1);

            public WithLinuxRootUsernameUnmanaged withStoredLinuxImage(String var1);

            public WithUnmanagedCreate withSpecializedOSUnmanagedDisk(String var1, OperatingSystemTypes var2);

            public WithManagedCreate withSpecializedOSDisk(Disk var1, OperatingSystemTypes var2);
        }

        public static interface WithProximityPlacementGroup
        extends WithOS {
            public WithOS withProximityPlacementGroup(String var1);

            public WithOS withNewProximityPlacementGroup(String var1, ProximityPlacementGroupType var2);
        }

        public static interface WithPrimaryNetworkInterface {
            public WithProximityPlacementGroup withNewPrimaryNetworkInterface(Creatable<NetworkInterface> var1);

            public WithProximityPlacementGroup withExistingPrimaryNetworkInterface(NetworkInterface var1);
        }

        public static interface WithPublicIPAddress {
            public WithProximityPlacementGroup withNewPrimaryPublicIPAddress(Creatable<PublicIpAddress> var1);

            public WithProximityPlacementGroup withNewPrimaryPublicIPAddress(String var1);

            public WithProximityPlacementGroup withExistingPrimaryPublicIPAddress(PublicIpAddress var1);

            public WithProximityPlacementGroup withoutPrimaryPublicIPAddress();
        }

        public static interface WithPrivateIP {
            public WithPublicIPAddress withPrimaryPrivateIPAddressDynamic();

            public WithPublicIPAddress withPrimaryPrivateIPAddressStatic(String var1);
        }

        public static interface WithSubnet {
            public WithPrivateIP withSubnet(String var1);
        }

        public static interface WithNetwork
        extends WithPrimaryNetworkInterface {
            public WithPrivateIP withNewPrimaryNetwork(Creatable<Network> var1);

            public WithPrivateIP withNewPrimaryNetwork(String var1);

            public WithSubnet withExistingPrimaryNetwork(Network var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface DefinitionUnmanaged
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithPrivateIP,
    DefinitionStages.WithPublicIPAddress,
    DefinitionStages.WithPrimaryNetworkInterface,
    DefinitionStages.WithOS,
    DefinitionStages.WithLinuxRootUsernameUnmanaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyUnmanaged,
    DefinitionStages.WithWindowsAdminUsernameUnmanaged,
    DefinitionStages.WithWindowsAdminPasswordUnmanaged,
    DefinitionStages.WithFromImageCreateOptionsUnmanaged,
    DefinitionStages.WithLinuxCreateUnmanaged,
    DefinitionStages.WithWindowsCreateUnmanaged,
    DefinitionStages.WithUnmanagedCreate {
    }

    public static interface DefinitionManaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameManaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyManaged,
    DefinitionStages.WithWindowsAdminUsernameManaged,
    DefinitionStages.WithWindowsAdminPasswordManaged,
    DefinitionStages.WithFromImageCreateOptionsManaged,
    DefinitionStages.WithLinuxCreateManaged,
    DefinitionStages.WithWindowsCreateManaged,
    DefinitionStages.WithManagedCreate {
    }

    public static interface DefinitionManagedOrUnmanaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameManagedOrUnmanaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged,
    DefinitionStages.WithWindowsAdminUsernameManagedOrUnmanaged,
    DefinitionStages.WithWindowsAdminPasswordManagedOrUnmanaged,
    DefinitionStages.WithFromImageCreateOptionsManagedOrUnmanaged,
    DefinitionStages.WithLinuxCreateManagedOrUnmanaged,
    DefinitionStages.WithWindowsCreateManagedOrUnmanaged,
    DefinitionStages.WithManagedCreate,
    DefinitionStages.WithUnmanagedCreate {
    }

    public static interface DefinitionShared
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithPrivateIP,
    DefinitionStages.WithPublicIPAddress,
    DefinitionStages.WithPrimaryNetworkInterface,
    DefinitionStages.WithOS,
    DefinitionStages.WithProximityPlacementGroup,
    DefinitionStages.WithSecurityFeatures,
    DefinitionStages.WithCreate {
    }
}

